/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c170.util;

import com.sun.xml.internal.txw2.output.IndentingXMLStreamWriter;
import es.aeat.pret.c170.api.bean.AscendienteBean;
import es.aeat.pret.c170.api.bean.DescendienteBean;
import es.aeat.pret.c170.api.bean.PerceptorBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StaxEscribirFichero
implements Serializable {
    private static final long serialVersionUID = 1L;
    FileOutputStream os;
    XMLOutputFactory xof;
    XMLStreamWriter writer = null;
    PerceptorBean modelo = null;
    boolean terminado = false;

    public boolean isTerminado() {
        return this.terminado;
    }

    public void startDocument(PerceptorBean modelo, File ficheroSalida) {
        this.xof = XMLOutputFactory.newInstance();
        this.modelo = modelo;
        this.writer = null;
        try {
            this.os = new FileOutputStream(ficheroSalida);
            this.writer = new IndentingXMLStreamWriter(this.xof.createXMLStreamWriter(this.os, "ISO-8859-1"));
            this.xof = null;
            this.writer.writeStartDocument("ISO-8859-1", "1.0");
            this.writer.writeStartElement("AEATRetencionesSalida2017");
            this.writer.writeAttribute("Sello", "             ");
            this.writer.writeStartElement("IdDoc");
            this.writer.writeStartElement("CodModelo");
            this.writer.writeCharacters("RET");
            this.writer.writeEndElement();
            this.writer.writeStartElement("Ejercicio");
            this.writer.writeCharacters("2017");
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void endDocument() {
        try {
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.flush();
            this.writer.close();
            this.os.flush();
            this.os.close();
            this.writer = null;
            this.terminado = true;
            this.os = null;
            this.modelo = null;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endRetenedor() {
        try {
            this.writer.writeEndElement();
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void startRetenedor() {
        try {
            this.writer.writeStartElement("Retenedor");
            this.writer.writeStartElement("Nif");
            this.writer.writeCharacters((String)this.modelo.getValor("NIFRET"));
            this.writer.writeEndElement();
            this.writer.writeStartElement("ApellidosNombre");
            this.writer.writeCharacters((String)this.modelo.getValor("APERET"));
            this.writer.writeEndElement();
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void escribirRetenido() {
        try {
            this.writer.writeStartElement("Retenido");
            this.writer.writeStartElement("Nif");
            this.writer.writeCharacters((String)this.modelo.getValor("NIFPER"));
            this.writer.writeEndElement();
            this.writer.writeStartElement("ApellidosNombre");
            this.writer.writeCharacters((String)this.modelo.getValor("APEPER"));
            this.writer.writeEndElement();
            this.writer.writeStartElement("A\u00f1oNacimiento");
            this.writer.writeCharacters(((Integer)this.modelo.getValor("ANOPER")).toString());
            this.writer.writeEndElement();
            Boolean bool = (Boolean)this.modelo.getValor("RESICEME");
            if (bool.booleanValue()) {
                this.writer.writeEmptyElement("ResidenciaCeutaMelilla");
            }
            this.writer.writeStartElement("SituacionFamiliar");
            Integer integ = (Integer)this.modelo.getValor("SITUFAM");
            if (integ == 1) {
                this.writer.writeEmptyElement("Situacion1");
            } else if (integ == 2) {
                this.writer.writeStartElement("Situacion2");
                this.writer.writeStartElement("NifConyuge");
                this.writer.writeCharacters((String)this.modelo.getValor("NIFCON"));
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            } else if (integ == 3) {
                this.writer.writeEmptyElement("Situacion3");
            }
            this.writer.writeEndElement();
            integ = (Integer)this.modelo.getValor("DISCAPER");
            if (integ == 1) {
                this.writer.writeStartElement("Discapacidad");
                bool = (Boolean)this.modelo.getValor("MOVILPER");
                if (bool.booleanValue()) {
                    this.writer.writeStartElement("Grado1");
                    this.writer.writeEmptyElement("MovilidadReducida");
                    this.writer.writeEndElement();
                } else {
                    this.writer.writeEmptyElement("Grado1");
                }
                this.writer.writeEndElement();
            } else if (integ == 2) {
                this.writer.writeStartElement("Discapacidad");
                this.writer.writeEmptyElement("Grado2");
                this.writer.writeEndElement();
            }
            integ = (Integer)this.modelo.getValor("SITUPER");
            this.writer.writeStartElement("SituacionLaboral");
            if (integ == 1) {
                this.writer.writeStartElement("TrabajadorActivo");
                this.writer.writeStartElement("Contrato");
                this.writer.writeCharacters(((Integer)this.modelo.getValor("CONTRATO")).toString());
                this.writer.writeEndElement();
                bool = (Boolean)this.modelo.getValor("MOVIL");
                if (bool.booleanValue()) {
                    this.writer.writeStartElement("MovilidadGeografica");
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
            } else if (integ == 2) {
                this.writer.writeEmptyElement("Pensionista");
            } else if (integ == 3) {
                this.writer.writeEmptyElement("Desempleado");
            } else if (integ == 4) {
                this.writer.writeEmptyElement("OtraSituacion");
            }
            this.writer.writeEndElement();
            List<DescendienteBean> listaDesc = this.modelo.getDescendientes();
            this.escribirDescendientes(listaDesc);
            listaDesc = null;
            List<AscendienteBean> listaAsc = this.modelo.getAscendientes();
            this.escribirAscendientes(listaAsc);
            listaAsc = null;
            this.writer.writeStartElement("RetribAnuales");
            this.writer.writeCharacters(((BigDecimal)this.modelo.getValor("RETRIB")).toString());
            this.writer.writeEndElement();
            BigDecimal valor1 = (BigDecimal)this.modelo.getValor("IRREGULAR1");
            BigDecimal valor2 = (BigDecimal)this.modelo.getValor("IRREGULAR2");
            BigDecimal valor3 = null;
            if (valor1.compareTo(BigDecimal.ZERO) != 0 || valor2.compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("Reducciones");
                if (valor1.compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("Irregularidad1");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                }
                if (valor2.compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("Irregularidad2");
                    this.writer.writeCharacters(valor2.toString());
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
            }
            if ((valor1 = (BigDecimal)this.modelo.getValor("COTIZACIONES")).compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("Cotizaciones");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            if ((valor1 = (BigDecimal)this.modelo.getValor("CONYUGE")).compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("PensionCompensatoria");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            if ((valor1 = (BigDecimal)this.modelo.getValor("ANUALIDADES")).compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("AnualidadesHijos");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("RENCEME")).booleanValue()) {
                this.writer.writeEmptyElement("RdtosObtenidosCeutaMelilla");
            }
            if ((bool = (Boolean)this.modelo.getValor("PRESVIV")).booleanValue()) {
                this.writer.writeEmptyElement("PagoPrestamosVivienda");
            }
            if ((bool = (Boolean)this.modelo.getValor("REGULARIZACION")).booleanValue()) {
                this.escribirCausas();
                valor1 = (BigDecimal)this.modelo.getValor("PERCIBIDO");
                this.writer.writeStartElement("RetribSatisfechas");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
                valor1 = (BigDecimal)this.modelo.getValor("RETENIDO");
                if (valor1.compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("RetencionPracticada");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                }
                if ((valor1 = (BigDecimal)this.modelo.getValor("RETRIBA")).compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("RetribAnualesIniciales");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                }
                if ((valor1 = (BigDecimal)this.modelo.getValor("IMPORTEA")).compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("RetencionAnualInicial");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                }
                if ((valor1 = (BigDecimal)this.modelo.getValor("BASEA")).compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("BaseRetencion");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                }
                valor1 = (BigDecimal)this.modelo.getValor("TIPOA");
                this.writer.writeStartElement("TipoRetencion");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
                bool = (Boolean)this.modelo.getValor("RENCEMEA");
                if (bool.booleanValue()) {
                    this.writer.writeEmptyElement("ResidenciaInicialCeutaMelilla");
                }
                if ((valor1 = (BigDecimal)this.modelo.getValor("MINPERFAA")).compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("MinimoPersonalFamiliarInicial");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                }
                if ((bool = (Boolean)this.modelo.getValor("MINORADO")).booleanValue()) {
                    valor1 = (BigDecimal)this.modelo.getValor("MINOPAGOA");
                    this.writer.writeStartElement("MinoracionPrestamosVivienda");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("Gastos");
            this.writer.writeStartElement("OtrosGastos");
            this.writer.writeStartElement("General");
            valor1 = (BigDecimal)this.modelo.getValor("GASTOSGEN");
            this.writer.writeCharacters(valor1.toString());
            this.writer.writeEndElement();
            valor1 = (BigDecimal)this.modelo.getValor("INCREGASMOVIL");
            if (valor1.compareTo(BigDecimal.ZERO) > 0) {
                this.writer.writeStartElement("MovilidadGeografica");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            if ((valor1 = (BigDecimal)this.modelo.getValor("INCREGASDISTRA")).compareTo(BigDecimal.ZERO) > 0) {
                this.writer.writeStartElement("DiscapacidadTrabajadoresActivos");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            valor1 = (BigDecimal)this.modelo.getValor("OTROSGASTOS");
            this.writer.writeStartElement("Total");
            this.writer.writeCharacters(valor1.toString());
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            valor1 = (BigDecimal)this.modelo.getValor("GASTOS");
            this.writer.writeStartElement("Total");
            this.writer.writeCharacters(valor1.toString());
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            valor1 = (BigDecimal)this.modelo.getValor("RNT");
            if (valor1.compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("RdtoNeto");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            if ((valor1 = (BigDecimal)this.modelo.getValor("RNTREDU")).compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("RdtoNetoReducido");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            if ((valor1 = (BigDecimal)this.modelo.getValor("MINOPAGO")).compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("MinoracionPrestamo");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("MinimoPersonalFamiliar");
            this.writer.writeStartElement("MinimoCtye");
            this.writer.writeStartElement("General");
            this.writer.writeCharacters(((BigDecimal)this.modelo.getValor("MINPER")).toString());
            this.writer.writeEndElement();
            valor1 = (BigDecimal)this.modelo.getValor("PER65");
            if (valor1.compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("Edad");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            if ((valor1 = (BigDecimal)this.modelo.getValor("PER75")).compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("Asistencia");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("Total");
            this.writer.writeCharacters(((BigDecimal)this.modelo.getValor("MINCON")).toString());
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            Integer num = (Integer)this.modelo.getValor("NUMDES");
            if (num > 0) {
                this.writer.writeStartElement("MinimoDescendientes");
                valor1 = (BigDecimal)this.modelo.getValor("MINDESG");
                this.writer.writeStartElement("General");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
                valor1 = (BigDecimal)this.modelo.getValor("MINDES3");
                if (valor1.compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("CuidadoHijos");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                }
                valor2 = (BigDecimal)this.modelo.getValor("MINDES");
                this.writer.writeStartElement("Total");
                this.writer.writeCharacters(valor2.toString());
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
            if ((num = (Integer)this.modelo.getValor("NUMAS")) > 0) {
                this.writer.writeStartElement("MinimoAscendientes");
                valor1 = (BigDecimal)this.modelo.getValor("AS65");
                this.writer.writeStartElement("Edad");
                this.writer.writeCharacters(valor1.toString());
                this.writer.writeEndElement();
                valor1 = (BigDecimal)this.modelo.getValor("AS75");
                if (valor1.compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("Asistencia");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                }
                valor2 = (BigDecimal)this.modelo.getValor("MINAS");
                this.writer.writeStartElement("Total");
                this.writer.writeCharacters(valor2.toString());
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
            if ((valor2 = (BigDecimal)this.modelo.getValor("MINDIS")).compareTo(BigDecimal.ZERO) != 0) {
                this.writer.writeStartElement("MinimoDiscapacidad");
                valor3 = (BigDecimal)this.modelo.getValor("MINDISC");
                if (valor3.compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("DiscapacidadCtye");
                    valor1 = (BigDecimal)this.modelo.getValor("DISPER");
                    this.writer.writeStartElement("Discapacidad");
                    this.writer.writeCharacters(valor1.toString());
                    this.writer.writeEndElement();
                    valor1 = (BigDecimal)this.modelo.getValor("ASISPER");
                    if (valor1.compareTo(BigDecimal.ZERO) != 0) {
                        this.writer.writeStartElement("Asistencia");
                        this.writer.writeCharacters(valor1.toString());
                        this.writer.writeEndElement();
                    }
                    this.writer.writeStartElement("Total");
                    this.writer.writeCharacters(valor3.toString());
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
                if ((valor3 = (BigDecimal)this.modelo.getValor("MDISDEAS")).compareTo(BigDecimal.ZERO) != 0) {
                    this.writer.writeStartElement("DiscapacidadDescAsc");
                    valor1 = (BigDecimal)this.modelo.getValor("DISDES");
                    if (valor1.compareTo(BigDecimal.ZERO) != 0) {
                        this.writer.writeStartElement("DiscapacidadDesc");
                        this.writer.writeCharacters(valor1.toString());
                        this.writer.writeEndElement();
                    }
                    if ((valor1 = (BigDecimal)this.modelo.getValor("ASISDES")).compareTo(BigDecimal.ZERO) != 0) {
                        this.writer.writeStartElement("AsistenciaDesc");
                        this.writer.writeCharacters(valor1.toString());
                        this.writer.writeEndElement();
                    }
                    if ((valor1 = (BigDecimal)this.modelo.getValor("DISAS")).compareTo(BigDecimal.ZERO) != 0) {
                        this.writer.writeStartElement("DiscapacidadAsc");
                        this.writer.writeCharacters(valor1.toString());
                        this.writer.writeEndElement();
                    }
                    if ((valor1 = (BigDecimal)this.modelo.getValor("ASISAS")).compareTo(BigDecimal.ZERO) != 0) {
                        this.writer.writeStartElement("AsistenciaAsc");
                        this.writer.writeCharacters(valor1.toString());
                        this.writer.writeEndElement();
                    }
                    this.writer.writeStartElement("Total");
                    this.writer.writeCharacters(valor3.toString());
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
                this.writer.writeStartElement("Total");
                this.writer.writeCharacters(valor2.toString());
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("Total");
            this.writer.writeCharacters(((BigDecimal)this.modelo.getValor("MINPERFA")).toString());
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeStartElement("Reduccion");
            valor1 = BigDecimal.ZERO;
            valor1 = (BigDecimal)this.modelo.getValor("RED20");
            this.writer.writeStartElement("RdtosTrabajo");
            this.writer.writeCharacters(valor1.toString());
            this.writer.writeEndElement();
            valor2 = (BigDecimal)this.modelo.getValor("HIJOS");
            if (valor2.compareTo(BigDecimal.ZERO) != 0) {
                valor1 = valor1.add(valor2);
                this.writer.writeStartElement("ReduccionMas2");
                this.writer.writeCharacters(valor2.toString());
                this.writer.writeEndElement();
            }
            if ((valor2 = (BigDecimal)this.modelo.getValor("PENSION")).compareTo(BigDecimal.ZERO) != 0) {
                valor1 = valor1.add(valor2);
                this.writer.writeStartElement("Pensionista");
                this.writer.writeCharacters(valor2.toString());
                this.writer.writeEndElement();
            }
            if ((valor2 = (BigDecimal)this.modelo.getValor("DESEM")).compareTo(BigDecimal.ZERO) != 0) {
                valor1 = valor1.add(valor2);
                this.writer.writeStartElement("Desempleado");
                this.writer.writeCharacters(valor2.toString());
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            valor1 = (BigDecimal)this.modelo.getValor("BASE");
            this.writer.writeStartElement("BaseRetencion");
            this.writer.writeCharacters(valor1.toString());
            this.writer.writeEndElement();
            valor1 = (BigDecimal)this.modelo.getValor("IMPORTE");
            this.writer.writeStartElement("ImpAnualRetencionesIngresosCuenta");
            this.writer.writeCharacters(valor1.toString());
            this.writer.writeEndElement();
            bool = (Boolean)this.modelo.getValor("REGULARIZACION");
            valor1 = bool != false ? (BigDecimal)this.modelo.getValor("TIPOREG") : (BigDecimal)this.modelo.getValor("TIPO");
            this.writer.writeStartElement("TipoRetencion");
            this.writer.writeCharacters(valor1.toString());
            this.writer.writeEndElement();
            this.escribirComputoDescendientes(this.modelo.getDescendientes().size());
            this.escribirComputoAscendientes(this.modelo.getAscendientes().size());
            valor1 = null;
            valor2 = null;
            valor3 = null;
            bool = null;
            integ = null;
            num = null;
            this.writer.writeEndElement();
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void escribirComputoDescendientes(int num) {
        try {
            Integer entero = 0;
            if (num != 0) {
                Integer cuatro;
                this.writer.writeStartElement("Descendientes");
                this.writer.writeStartElement("ComputoDescendientes");
                if (!this.modelo.getValor("COMHIJO1").equals("")) {
                    this.writer.writeStartElement("Hijo1");
                    this.writer.writeCharacters((String)this.modelo.getValor("COMHIJO1"));
                    this.writer.writeEndElement();
                }
                if (!this.modelo.getValor("COMHIJO2").equals("")) {
                    this.writer.writeStartElement("Hijo2");
                    this.writer.writeCharacters((String)this.modelo.getValor("COMHIJO2"));
                    this.writer.writeEndElement();
                }
                if (!this.modelo.getValor("COMHIJO3").equals("")) {
                    this.writer.writeStartElement("Hijo3");
                    this.writer.writeCharacters((String)this.modelo.getValor("COMHIJO3"));
                    this.writer.writeEndElement();
                }
                if ((cuatro = (Integer)this.modelo.getValor("NUMDESMAS3")) > 0) {
                    this.writer.writeStartElement("CuartoySucesivos");
                    this.writer.writeStartElement("Total");
                    this.writer.writeCharacters(cuatro.toString());
                    this.writer.writeEndElement();
                    entero = (Integer)this.modelo.getValor("NUMDESMAS3EN");
                    if (entero > 0) {
                        this.writer.writeStartElement("PorEntero");
                        this.writer.writeCharacters(entero.toString());
                        this.writer.writeEndElement();
                    }
                    this.writer.writeEndElement();
                }
                cuatro = null;
                this.writer.writeEndElement();
                Integer menores = (Integer)this.modelo.getValor("NUMDES3");
                if (menores > 0) {
                    this.writer.writeStartElement("Menores3A\u00f1os");
                    this.writer.writeStartElement("Total");
                    this.writer.writeCharacters(menores.toString());
                    this.writer.writeEndElement();
                    entero = (Integer)this.modelo.getValor("NUMDES3EN");
                    if (entero > 0) {
                        this.writer.writeStartElement("PorEntero");
                        this.writer.writeCharacters(entero.toString());
                        this.writer.writeEndElement();
                    }
                    this.writer.writeEndElement();
                }
                menores = null;
                Integer resto = (Integer)this.modelo.getValor("NUMDES325");
                if (resto > 0) {
                    this.writer.writeStartElement("Resto");
                    this.writer.writeStartElement("Total");
                    this.writer.writeCharacters(resto.toString());
                    this.writer.writeEndElement();
                    entero = (Integer)this.modelo.getValor("NUMDES325EN");
                    if (entero > 0) {
                        this.writer.writeStartElement("PorEntero");
                        this.writer.writeCharacters(entero.toString());
                        this.writer.writeEndElement();
                    }
                    this.writer.writeEndElement();
                }
                resto = null;
                Integer disc3365 = (Integer)this.modelo.getValor("NUMDES3365");
                Integer disc65 = (Integer)this.modelo.getValor("NUMDES65");
                Integer movRed = (Integer)this.modelo.getValor("NUMDESMOV");
                if (disc3365 + disc65 + movRed > 0) {
                    this.writer.writeStartElement("ConDiscapacidad");
                    if (disc3365 > 0) {
                        this.writer.writeStartElement("EnGrado1");
                        this.writer.writeStartElement("Total");
                        this.writer.writeCharacters(disc3365.toString());
                        this.writer.writeEndElement();
                        entero = (Integer)this.modelo.getValor("NUMDES3365EN");
                        if (entero > 0) {
                            this.writer.writeStartElement("PorEntero");
                            this.writer.writeCharacters(entero.toString());
                            this.writer.writeEndElement();
                        }
                        if (movRed > 0) {
                            this.writer.writeStartElement("ConMovilidadReducida");
                            this.writer.writeStartElement("Total");
                            this.writer.writeCharacters(movRed.toString());
                            this.writer.writeEndElement();
                            entero = (Integer)this.modelo.getValor("NUMDESMOVEN");
                            if (entero > 0) {
                                this.writer.writeStartElement("PorEntero");
                                this.writer.writeCharacters(entero.toString());
                                this.writer.writeEndElement();
                            }
                            this.writer.writeEndElement();
                        }
                        this.writer.writeEndElement();
                    }
                    if (disc65 > 0) {
                        this.writer.writeStartElement("EnGrado2");
                        this.writer.writeStartElement("Total");
                        this.writer.writeCharacters(disc65.toString());
                        this.writer.writeEndElement();
                        entero = (Integer)this.modelo.getValor("NUMDES65EN");
                        if (entero > 0) {
                            this.writer.writeStartElement("PorEntero");
                            this.writer.writeCharacters(entero.toString());
                            this.writer.writeEndElement();
                        }
                        this.writer.writeEndElement();
                    }
                    this.writer.writeEndElement();
                }
                disc3365 = null;
                disc65 = null;
                movRed = null;
                entero = null;
                this.writer.writeEndElement();
            }
            entero = null;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void escribirComputoAscendientes(int num) {
        try {
            if (num != 0) {
                Integer entero = 0;
                this.writer.writeStartElement("Ascendientes");
                Integer menores = (Integer)this.modelo.getValor("NUMAS65A");
                if (menores > 0) {
                    this.writer.writeStartElement("Menores75");
                    this.writer.writeStartElement("Total");
                    this.writer.writeCharacters(menores.toString());
                    this.writer.writeEndElement();
                    entero = (Integer)this.modelo.getValor("NUMAS65AEN");
                    if (entero > 0) {
                        this.writer.writeStartElement("PorEntero");
                        this.writer.writeCharacters(entero.toString());
                        this.writer.writeEndElement();
                    }
                    this.writer.writeEndElement();
                }
                menores = null;
                Integer mayores = (Integer)this.modelo.getValor("NUMAS75A");
                if (mayores > 0) {
                    this.writer.writeStartElement("Mayores75");
                    this.writer.writeStartElement("Total");
                    this.writer.writeCharacters(mayores.toString());
                    this.writer.writeEndElement();
                    entero = (Integer)this.modelo.getValor("NUMAS75AEN");
                    if (entero > 0) {
                        this.writer.writeStartElement("PorEntero");
                        this.writer.writeCharacters(entero.toString());
                        this.writer.writeEndElement();
                    }
                    this.writer.writeEndElement();
                }
                mayores = null;
                Integer disc3365 = (Integer)this.modelo.getValor("NUMAS3365");
                Integer disc65 = (Integer)this.modelo.getValor("NUMAS65");
                Integer movRed = (Integer)this.modelo.getValor("NUMASMOV");
                if (disc3365 + disc65 + movRed > 0) {
                    this.writer.writeStartElement("ConDiscapacidad");
                    if (disc3365 > 0) {
                        this.writer.writeStartElement("EnGrado1");
                        this.writer.writeStartElement("Total");
                        this.writer.writeCharacters(disc3365.toString());
                        this.writer.writeEndElement();
                        entero = (Integer)this.modelo.getValor("NUMAS3365EN");
                        if (entero > 0) {
                            this.writer.writeStartElement("PorEntero");
                            this.writer.writeCharacters(entero.toString());
                            this.writer.writeEndElement();
                        }
                        if (movRed > 0) {
                            this.writer.writeStartElement("ConMovilidadReducida");
                            this.writer.writeStartElement("Total");
                            this.writer.writeCharacters(movRed.toString());
                            this.writer.writeEndElement();
                            entero = (Integer)this.modelo.getValor("NUMASMOVEN");
                            if (entero > 0) {
                                this.writer.writeStartElement("PorEntero");
                                this.writer.writeCharacters(entero.toString());
                                this.writer.writeEndElement();
                            }
                            this.writer.writeEndElement();
                        }
                        movRed = null;
                        this.writer.writeEndElement();
                    }
                    if (disc65 > 0) {
                        this.writer.writeStartElement("EnGrado2");
                        this.writer.writeStartElement("Total");
                        this.writer.writeCharacters(disc65.toString());
                        this.writer.writeEndElement();
                        entero = (Integer)this.modelo.getValor("NUMAS65EN");
                        if (entero > 0) {
                            this.writer.writeStartElement("PorEntero");
                            this.writer.writeCharacters(entero.toString());
                            this.writer.writeEndElement();
                        }
                        this.writer.writeEndElement();
                    }
                    this.writer.writeEndElement();
                }
                disc65 = null;
                disc3365 = null;
                movRed = null;
                entero = null;
                this.writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void escribirCausas() {
        try {
            this.writer.writeStartElement("Regularizacion");
            Boolean bool = (Boolean)this.modelo.getValor("CAUSA", 1);
            if (bool.booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("1");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 2)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("2");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 3)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("3");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 4)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("4");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 5)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("5");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 6)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("6");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 7)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("7");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 8)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("8");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 9)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("9");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 10)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("10");
                this.writer.writeEndElement();
            }
            if ((bool = (Boolean)this.modelo.getValor("CAUSA", 11)).booleanValue()) {
                this.writer.writeStartElement("Causa");
                this.writer.writeCharacters("11");
                this.writer.writeEndElement();
            }
            bool = null;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void escribirDescendientes(List<? extends DescendienteBean> lista) {
        try {
            int num = lista.size();
            int i = 0;
            while (i < num) {
                DescendienteBean des = lista.get(i);
                this.writer.writeStartElement("Descendiente");
                this.writer.writeStartElement("A\u00f1oNacimiento");
                this.writer.writeCharacters(des.getAnioNacimiento().toString());
                this.writer.writeEndElement();
                if (des.getAnioAdopcion() != 0) {
                    this.writer.writeStartElement("A\u00f1oAdopcion");
                    this.writer.writeCharacters(des.getAnioAdopcion().toString());
                    this.writer.writeEndElement();
                }
                if (des.isPorEntero()) {
                    this.writer.writeEmptyElement("ComputadoEntero");
                }
                if (des.getDiscapacidad() == 1) {
                    this.writer.writeStartElement("Discapacidad");
                    if (des.isMovilidadReducida()) {
                        this.writer.writeStartElement("Grado1");
                        this.writer.writeEmptyElement("MovilidadReducida");
                        this.writer.writeEndElement();
                    } else {
                        this.writer.writeEmptyElement("Grado1");
                    }
                    this.writer.writeEndElement();
                } else if (des.getDiscapacidad() == 2) {
                    this.writer.writeStartElement("Discapacidad");
                    this.writer.writeEmptyElement("Grado2");
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
                ++i;
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void escribirAscendientes(List<AscendienteBean> lista) {
        try {
            int num = lista.size();
            int i = 0;
            while (i < num) {
                AscendienteBean asc = lista.get(i);
                this.writer.writeStartElement("Ascendiente");
                this.writer.writeStartElement("A\u00f1oNacimiento");
                this.writer.writeCharacters(asc.getAnioNacimiento().toString());
                this.writer.writeEndElement();
                this.writer.writeStartElement("Convivencia");
                this.writer.writeCharacters(asc.getConvivencia().toString());
                this.writer.writeEndElement();
                if (asc.getDiscapacidad() == 1) {
                    this.writer.writeStartElement("Discapacidad");
                    if (asc.isMovilidadReducida()) {
                        this.writer.writeStartElement("Grado1");
                        this.writer.writeEmptyElement("MovilidadReducida");
                        this.writer.writeEndElement();
                    } else {
                        this.writer.writeEmptyElement("Grado1");
                    }
                    this.writer.writeEndElement();
                } else if (asc.getDiscapacidad() == 2) {
                    this.writer.writeStartElement("Discapacidad");
                    this.writer.writeEmptyElement("Grado2");
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
                ++i;
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }
}

