/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c170.util;

import es.aeat.pret.c170.api.bean.AscendienteBean;
import es.aeat.pret.c170.api.bean.DescendienteBean;
import es.aeat.pret.c170.api.bean.PerceptorBean;
import es.aeat.pret.c170.util.NombreNif;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaxLeerRetenido
implements Serializable {
    private static final long serialVersionUID = 1L;
    private XMLInputFactory factory = null;
    private final HashMap<String, Element> nameToTypeMapping = new HashMap();
    private StringBuilder currentText;
    private Element currentElement;
    private PerceptorBean modelo = null;
    private ArrayList<NombreNif> lista = null;
    private NombreNif retenido;
    String nif;
    ArrayList<Integer> causas = null;
    int tipoRetiDescAsc = 0;
    List<DescendienteBean> datosDescendientes = null;
    List<AscendienteBean> datosAscendientes = null;
    DescendienteBean descend = null;
    AscendienteBean ascend = null;
    int indiceRetenedorALeer;
    int indiceRetenedorLeido = -1;
    int indiceRetenidoALeer;
    int indiceRetenidoLeido = -1;
    boolean estamosRetenido = false;
    XMLStreamReader xmlReader = null;
    boolean importarXML = false;
    boolean buscarRetenido = false;
    boolean retenidoEncontrado = false;

    public StaxLeerRetenido() {
        this.nameToTypeMapping.put("Nif", Element.Nif);
        this.nameToTypeMapping.put("ApellidosNombre", Element.ApellidosNombre);
        this.nameToTypeMapping.put("A\u00f1oNacimiento", Element.A\u00f1oNacimiento);
        this.nameToTypeMapping.put("comunidadAutonoma", Element.comunidadAutonoma);
        this.nameToTypeMapping.put("ResidenciaCeutaMelilla", Element.ResidenciaCeutaMelilla);
        this.nameToTypeMapping.put("Situacion1", Element.Situacion1);
        this.nameToTypeMapping.put("Situacion2", Element.Situacion2);
        this.nameToTypeMapping.put("NifConyuge", Element.NifConyuge);
        this.nameToTypeMapping.put("Situacion3", Element.Situacion3);
        this.nameToTypeMapping.put("Grado1", Element.Grado1);
        this.nameToTypeMapping.put("Grado2", Element.Grado2);
        this.nameToTypeMapping.put("MovilidadReducida", Element.MovilidadReducida);
        this.nameToTypeMapping.put("TrabajadorActivo", Element.TrabajadorActivo);
        this.nameToTypeMapping.put("Desempleado", Element.Desempleado);
        this.nameToTypeMapping.put("Pensionista", Element.Pensionista);
        this.nameToTypeMapping.put("OtraSituacion", Element.OtraSituacion);
        this.nameToTypeMapping.put("Contrato", Element.Contrato);
        this.nameToTypeMapping.put("MovilidadGeografica", Element.MovilidadGeografica);
        this.nameToTypeMapping.put("Descendiente", Element.Descendiente);
        this.nameToTypeMapping.put("Ascendiente", Element.Ascendiente);
        this.nameToTypeMapping.put("A\u00f1oAdopcion", Element.A\u00f1oAdopcion);
        this.nameToTypeMapping.put("ComputadoEntero", Element.ComputadoEntero);
        this.nameToTypeMapping.put("Convivencia", Element.Convivencia);
        this.nameToTypeMapping.put("RetribAnuales", Element.RetribAnuales);
        this.nameToTypeMapping.put("Retenido", Element.Retenido);
        this.nameToTypeMapping.put("Retenedor", Element.Retenedor);
        this.nameToTypeMapping.put("Irregularidad1", Element.Irregularidad1);
        this.nameToTypeMapping.put("Irregularidad2", Element.Irregularidad2);
        this.nameToTypeMapping.put("Cotizaciones", Element.Cotizaciones);
        this.nameToTypeMapping.put("PensionCompensatoria", Element.PensionCompensatoria);
        this.nameToTypeMapping.put("AnualidadesHijos", Element.AnualidadesHijos);
        this.nameToTypeMapping.put("RdtosObtenidosCeutaMelilla", Element.RdtosObtenidosCeutaMelilla);
        this.nameToTypeMapping.put("PagoPrestamosVivienda", Element.PagoPrestamosVivienda);
        this.nameToTypeMapping.put("Causa", Element.Causa);
        this.nameToTypeMapping.put("RetribSatisfechas", Element.RetribSatisfechas);
        this.nameToTypeMapping.put("RetencionPracticada", Element.RetencionPracticada);
        this.nameToTypeMapping.put("RetribAnualesIniciales", Element.RetribAnualesIniciales);
        this.nameToTypeMapping.put("RetencionAnualInicial", Element.RetencionAnualInicial);
        this.nameToTypeMapping.put("ResidenciaInicialCeutaMelilla", Element.ResidenciaInicialCeutaMelilla);
        this.nameToTypeMapping.put("MinimoPersonalFamiliarInicial", Element.MinimoPersonalFamiliarInicial);
        this.nameToTypeMapping.put("BaseRetencion", Element.BaseRetencion);
        this.nameToTypeMapping.put("TipoRetencion", Element.TipoRetencion);
        this.nameToTypeMapping.put("MinoracionPrestamosVivienda", Element.MinoracionPrestamosVivienda);
        this.nameToTypeMapping.put("AEATRetencionesEntrada2017", Element.AEATRetencionesEntrada2017);
        this.nameToTypeMapping.put("IdDoc", Element.IdDoc);
        this.nameToTypeMapping.put("CodModelo", Element.CodModelo);
        this.nameToTypeMapping.put("Ejercicio", Element.Ejercicio);
    }

    public void preparamosLectura() {
        this.indiceRetenedorLeido = -1;
        this.indiceRetenidoLeido = -1;
    }

    public void crearXMLReader(FileInputStream input, PerceptorBean modelo, boolean importarXML, boolean buscarRetenido) throws XMLStreamException {
        if (this.factory == null) {
            this.factory = XMLInputFactory.newInstance();
        }
        if (this.xmlReader == null) {
            this.xmlReader = this.factory.createXMLStreamReader(input);
        }
        this.modelo = modelo;
        this.importarXML = importarXML;
        this.buscarRetenido = buscarRetenido;
    }

    public void borrarLista() {
        if (this.lista != null) {
            this.lista = null;
        }
    }

    public void cerrarReader() {
        try {
            if (this.lista != null) {
                this.lista = null;
            }
            if (this.xmlReader != null) {
                this.xmlReader.close();
                this.xmlReader = null;
            }
            this.modelo = null;
            this.factory = null;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void readXml(int indiceRetenedor, int indiceRetenido) throws XMLStreamException {
        this.indiceRetenedorALeer = indiceRetenedor;
        this.indiceRetenidoALeer = indiceRetenido;
        while (this.xmlReader.hasNext()) {
            int eventType = this.xmlReader.next();
            switch (eventType) {
                case 11: {
                    break;
                }
                case 5: {
                    break;
                }
                case 12: {
                    break;
                }
                case 6: {
                    break;
                }
                case 4: {
                    this.processText(this.xmlReader.getText());
                    break;
                }
                case 2: {
                    if (!this.ended(this.xmlReader.getLocalName())) break;
                    return;
                }
                case 1: {
                    this.startElement(this.xmlReader.getLocalName());
                    break;
                }
            }
        }
    }

    private void startElement(String localName) throws XMLStreamException {
        this.currentElement = this.nameToTypeMapping.get(localName);
        this.currentText = new StringBuilder(256);
        if (this.currentElement == Element.AEATRetencionesEntrada2017 || this.currentElement == Element.IdDoc || this.currentElement == Element.CodModelo || this.currentElement == Element.Ejercicio) {
            return;
        }
        if (this.modelo == null) {
            if (this.currentElement == Element.Retenedor) {
                this.estamosRetenido = false;
                ++this.indiceRetenedorLeido;
                this.indiceRetenidoLeido = -1;
                if (this.indiceRetenedorALeer == this.indiceRetenedorLeido) {
                    this.lista = new ArrayList();
                }
                return;
            }
            if (this.currentElement == Element.Retenido) {
                if (this.buscarRetenido) {
                    ++this.indiceRetenidoLeido;
                }
                this.estamosRetenido = true;
                this.retenido = new NombreNif();
                return;
            }
            return;
        }
        if (this.currentElement == Element.Retenedor) {
            this.estamosRetenido = false;
            ++this.indiceRetenedorLeido;
            this.indiceRetenidoLeido = -1;
            return;
        }
        if (this.currentElement == Element.Retenido) {
            this.estamosRetenido = true;
            this.retenido = new NombreNif();
            ++this.indiceRetenidoLeido;
            String nifRete = (String)this.modelo.getValor("NIFRET");
            String nombreRete = (String)this.modelo.getValor("APERET");
            this.modelo.borraDatos();
            this.modelo.setValor("NIFRET", nifRete);
            this.modelo.setValor("APERET", nombreRete);
            return;
        }
        if (this.indiceRetenedorALeer != this.indiceRetenedorLeido || this.indiceRetenidoALeer != this.indiceRetenidoLeido) {
            return;
        }
        if (this.currentElement == Element.Nif) {
            this.retenidoEncontrado = true;
            if (this.estamosRetenido) {
                this.tipoRetiDescAsc = 1;
            }
            return;
        }
        if (this.currentElement == Element.Descendiente) {
            this.tipoRetiDescAsc = 2;
            this.descend = this.modelo.createDescendienteBean();
            this.datosDescendientes = this.modelo.getDescendientes();
            return;
        }
        if (this.currentElement == Element.Ascendiente) {
            this.tipoRetiDescAsc = 3;
            this.ascend = this.modelo.createAscendienteBean();
            this.datosAscendientes = this.modelo.getAscendientes();
            return;
        }
        if (this.currentElement == Element.A\u00f1oNacimiento) {
            if (this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                if (this.tipoRetiDescAsc == 2) {
                    this.descend.setAnioAdopcion(0);
                    this.descend.setPorEntero(false);
                    this.descend.setDiscapacidad(0);
                    this.descend.setMovilidadReducida(false);
                } else if (this.tipoRetiDescAsc == 3) {
                    this.ascend.setConvivencia(0);
                    this.ascend.setDiscapacidad(0);
                    this.ascend.setMovilidadReducida(false);
                }
            }
            return;
        }
        if (this.currentElement == Element.Grado1) {
            if (this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                if (this.tipoRetiDescAsc == 1) {
                    this.modelo.setValor("MOVILPER", "0");
                }
                if (this.tipoRetiDescAsc == 2) {
                    this.descend.setDiscapacidad(0);
                }
                if (this.tipoRetiDescAsc == 3) {
                    this.ascend.setDiscapacidad(0);
                }
            }
            return;
        }
        if (this.currentElement == Element.TrabajadorActivo) {
            if (this.modelo != null && this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                this.modelo.setValor("MOVIL", "0");
            }
            return;
        }
        if (this.currentElement == Element.RetribAnuales) {
            if (this.modelo != null && this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                this.modelo.setValor("RENCEME", "0");
                this.modelo.setValor("PRESVIV", "0");
            }
            return;
        }
    }

    private boolean ended(String localName) {
        block67: {
            block69: {
                block68: {
                    this.currentElement = this.nameToTypeMapping.get(localName);
                    if (this.currentElement == null) break block67;
                    if (this.currentElement == Element.AEATRetencionesEntrada2017 || this.currentElement == Element.IdDoc || this.currentElement == Element.CodModelo || this.currentElement == Element.Ejercicio) {
                        return false;
                    }
                    if (this.modelo != null) break block68;
                    if (this.indiceRetenedorALeer != this.indiceRetenedorLeido) {
                        return false;
                    }
                    if (!(this.currentElement.toString().equalsIgnoreCase("Nif") || this.currentElement.toString().equalsIgnoreCase("ApellidosNombre") || this.currentElement.toString().equalsIgnoreCase("Retenido") || this.currentElement.toString().equalsIgnoreCase("Retenedor"))) {
                        return false;
                    }
                    switch (this.currentElement) {
                        case Nif: {
                            if (this.estamosRetenido) {
                                this.retenido.setNif(this.currentText.toString());
                                break;
                            }
                            break block69;
                        }
                        case ApellidosNombre: {
                            if (this.estamosRetenido) {
                                this.retenido.setNombre(this.currentText.toString());
                                break;
                            }
                            break block69;
                        }
                        case Retenido: {
                            if (this.buscarRetenido && this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                                this.lista.add(this.retenido);
                            } else if (!this.buscarRetenido) {
                                this.lista.add(this.retenido);
                            }
                            this.estamosRetenido = false;
                            this.retenido = null;
                            break;
                        }
                        case Retenedor: {
                            return true;
                        }
                    }
                    break block69;
                }
                if (this.indiceRetenedorALeer != this.indiceRetenedorLeido || this.indiceRetenidoALeer != this.indiceRetenidoLeido) {
                    return false;
                }
                switch (this.currentElement) {
                    case Nif: {
                        this.modelo.setValor("NIFPER", this.currentText.toString());
                        break;
                    }
                    case ApellidosNombre: {
                        if (!this.importarXML) {
                            this.modelo.setValor("APEPER", this.currentText.toString());
                            break;
                        }
                        this.modelo.setValor("APEPER", this.modelo.getValor("APERET"));
                        break;
                    }
                    case A\u00f1oNacimiento: {
                        if (this.tipoRetiDescAsc == 1) {
                            this.modelo.setValor("ANOPER", this.currentText.toString().trim());
                            break;
                        }
                        if (this.tipoRetiDescAsc == 2) {
                            this.descend.setAnioNacimiento(Integer.parseInt(this.currentText.toString().trim()));
                            break;
                        }
                        if (this.tipoRetiDescAsc != 3) break;
                        this.ascend.setAnioNacimiento(Integer.parseInt(this.currentText.toString().trim()));
                        break;
                    }
                    case Situacion1: {
                        this.modelo.setValor("SITUFAM", "1");
                        break;
                    }
                    case Situacion2: {
                        this.modelo.setValor("SITUFAM", "2");
                        break;
                    }
                    case NifConyuge: {
                        this.modelo.setValor("NIFCON", this.currentText.toString());
                        break;
                    }
                    case Situacion3: {
                        this.modelo.setValor("SITUFAM", "3");
                        break;
                    }
                    case Grado1: {
                        if (this.tipoRetiDescAsc == 1) {
                            this.modelo.setValor("DISCAPER", "1");
                        }
                        if (this.tipoRetiDescAsc == 2) {
                            this.descend.setDiscapacidad(1);
                        }
                        if (this.tipoRetiDescAsc != 3) break;
                        this.ascend.setDiscapacidad(1);
                        break;
                    }
                    case Grado2: {
                        if (this.tipoRetiDescAsc == 1) {
                            this.modelo.setValor("DISCAPER", "2");
                        }
                        if (this.tipoRetiDescAsc == 2) {
                            this.descend.setDiscapacidad(2);
                        }
                        if (this.tipoRetiDescAsc != 3) break;
                        this.ascend.setDiscapacidad(2);
                        break;
                    }
                    case MovilidadReducida: {
                        if (this.tipoRetiDescAsc == 1) {
                            this.modelo.setValor("MOVILPER", "1");
                        }
                        if (this.tipoRetiDescAsc == 2) {
                            this.descend.setMovilidadReducida(true);
                        }
                        if (this.tipoRetiDescAsc != 3) break;
                        this.ascend.setMovilidadReducida(true);
                        break;
                    }
                    case ResidenciaCeutaMelilla: {
                        this.modelo.setValor("RESICEME", "1");
                        break;
                    }
                    case TrabajadorActivo: {
                        this.modelo.setValor("SITUPER", "1");
                        break;
                    }
                    case Desempleado: {
                        this.modelo.setValor("SITUPER", "3");
                        break;
                    }
                    case Pensionista: {
                        this.modelo.setValor("SITUPER", "2");
                        break;
                    }
                    case OtraSituacion: {
                        this.modelo.setValor("SITUPER", "4");
                        break;
                    }
                    case Contrato: {
                        this.modelo.setValor("CONTRATO", this.currentText.toString().trim());
                        break;
                    }
                    case MovilidadGeografica: {
                        this.modelo.setValor("MOVIL", "1");
                        break;
                    }
                    case A\u00f1oAdopcion: {
                        this.descend.setAnioAdopcion(Integer.parseInt(this.currentText.toString().trim()));
                        break;
                    }
                    case ComputadoEntero: {
                        this.descend.setPorEntero(true);
                        break;
                    }
                    case Convivencia: {
                        this.ascend.setConvivencia(Integer.parseInt(this.currentText.toString().trim()));
                        break;
                    }
                    case Descendiente: {
                        this.datosDescendientes.add(this.descend);
                        break;
                    }
                    case Ascendiente: {
                        this.datosAscendientes.add(this.ascend);
                        break;
                    }
                    case RetribAnuales: {
                        this.modelo.setValor("RETRIB", this.currentText.toString().trim());
                        break;
                    }
                    case Irregularidad1: {
                        this.modelo.setValor("IRREGULAR1", this.currentText.toString().trim());
                        break;
                    }
                    case Irregularidad2: {
                        this.modelo.setValor("IRREGULAR2", this.currentText.toString().trim());
                        break;
                    }
                    case Cotizaciones: {
                        this.modelo.setValor("COTIZACIONES", this.currentText.toString().trim());
                        break;
                    }
                    case PensionCompensatoria: {
                        this.modelo.setValor("CONYUGE", this.currentText.toString().trim());
                        break;
                    }
                    case AnualidadesHijos: {
                        this.modelo.setValor("ANUALIDADES", this.currentText.toString().trim());
                        break;
                    }
                    case RdtosObtenidosCeutaMelilla: {
                        this.modelo.setValor("RENCEME", "1");
                        break;
                    }
                    case PagoPrestamosVivienda: {
                        this.modelo.setValor("PRESVIV", "1");
                        break;
                    }
                    case Causa: {
                        if (this.importarXML) break;
                        int indiceCausa = Integer.parseInt(this.currentText.toString().trim());
                        this.modelo.setValor("CAUSA", true, indiceCausa);
                        break;
                    }
                    case RetribSatisfechas: {
                        if (this.importarXML) break;
                        this.modelo.setValor("PERCIBIDO", this.currentText.toString().trim());
                        break;
                    }
                    case RetencionPracticada: {
                        if (this.importarXML) break;
                        this.modelo.setValor("RETENIDO", this.currentText.toString().trim());
                        break;
                    }
                    case RetribAnualesIniciales: {
                        if (this.importarXML) break;
                        this.modelo.setValor("RETRIBA", this.currentText.toString().trim());
                        break;
                    }
                    case RetencionAnualInicial: {
                        if (this.importarXML) break;
                        this.modelo.setValor("IMPORTEA", this.currentText.toString().trim());
                        break;
                    }
                    case ResidenciaInicialCeutaMelilla: {
                        if (this.importarXML) break;
                        this.modelo.setValor("RENCEMEA", "1");
                        break;
                    }
                    case BaseRetencion: {
                        if (this.importarXML) break;
                        this.modelo.setValor("BASEA", this.currentText.toString().trim());
                        break;
                    }
                    case MinimoPersonalFamiliarInicial: {
                        if (this.importarXML) break;
                        this.modelo.setValor("MINPERFAA", this.currentText.toString().trim());
                        break;
                    }
                    case TipoRetencion: {
                        if (this.importarXML) break;
                        this.modelo.setValor("TIPOA", this.currentText.toString().trim());
                        break;
                    }
                    case MinoracionPrestamosVivienda: {
                        if (this.importarXML) break;
                        this.modelo.setValor("MINORADO", "1");
                        this.modelo.setValor("MINOPAGOA", this.currentText.toString().trim());
                        break;
                    }
                    case Retenido: {
                        this.estamosRetenido = false;
                        this.datosAscendientes = null;
                        this.datosDescendientes = null;
                        this.descend = null;
                        this.causas = null;
                        return true;
                    }
                }
            }
            this.currentElement = null;
            this.currentText = null;
        }
        return false;
    }

    public ArrayList<String> getLista() {
        if (this.lista == null) {
            return null;
        }
        ArrayList<String> hm = new ArrayList<String>();
        int numl = this.lista.size();
        int i = 0;
        while (i < numl) {
            NombreNif nn = this.lista.get(i);
            hm.add(String.valueOf(nn.getNombre()) + "-" + nn.getNif());
            ++i;
        }
        return hm;
    }

    private void processText(String text) {
        if (this.currentElement != null && this.currentText != null) {
            this.currentText.append(text);
        }
    }

    public boolean encontrado() {
        return this.retenidoEncontrado;
    }

    private static enum Element {
        Nif,
        ApellidosNombre,
        A\u00f1oNacimiento,
        comunidadAutonoma,
        ResidenciaCeutaMelilla,
        Situacion1,
        Situacion2,
        NifConyuge,
        Situacion3,
        Grado1,
        Grado2,
        MovilidadReducida,
        TrabajadorActivo,
        Desempleado,
        Pensionista,
        OtraSituacion,
        Contrato,
        MovilidadGeografica,
        Descendiente,
        Ascendiente,
        A\u00f1oAdopcion,
        ComputadoEntero,
        Convivencia,
        Retenido,
        Retenedor,
        RetribAnuales,
        Irregularidad1,
        Irregularidad2,
        Cotizaciones,
        PensionCompensatoria,
        AnualidadesHijos,
        RdtosObtenidosCeutaMelilla,
        PagoPrestamosVivienda,
        Causa,
        RetribSatisfechas,
        RetencionPracticada,
        RetribAnualesIniciales,
        RetencionAnualInicial,
        ResidenciaInicialCeutaMelilla,
        MinimoPersonalFamiliarInicial,
        BaseRetencion,
        TipoRetencion,
        MinoracionPrestamosVivienda,
        AEATRetencionesEntrada2017,
        IdDoc,
        CodModelo,
        Ejercicio;

    }
}

