/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c170.imp.srv;

import es.aeat.pret.c170.api.PRET_C170_Factory;
import es.aeat.pret.c170.api.bean.PerceptorBean;
import es.aeat.pret.c170.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c170.api.srv.CalculoRetencionesXMLSrv;
import es.aeat.pret.c170.api.srv.ValidarLeerFicheroSrv;
import es.aeat.pret.c170.imp.srv.CalculoRetencionesSrvImpl;
import es.aeat.pret.c170.imp.srv.ValidarLeerFicheroSrvImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CalculoRetencionesXMLSrvImpl
implements CalculoRetencionesXMLSrv {
    private boolean huboErroresAntes = false;
    private int indiceRetenedor = 0;
    private int indiceRetenido = 0;
    private boolean cerradaSalidaPorError = true;
    private boolean abiertoRetenedor = false;
    private File ficheroSalida = null;
    private int numRetenidos = 0;
    private int numRetenedores = 0;
    private boolean errorValidacion = false;

    @Override
    public String procesar(File xml) {
        this.cerradaSalidaPorError = true;
        this.huboErroresAntes = false;
        this.errorValidacion = false;
        this.abiertoRetenedor = false;
        this.indiceRetenedor = 0;
        this.indiceRetenido = 0;
        this.ficheroSalida = null;
        CalculoRetencionesSrv retencionesSrv = System.getProperty("mc") != null ? new CalculoRetencionesSrvImpl() : PRET_C170_Factory.getCalculoRetencionesSrv();
        ValidarLeerFicheroSrv validaFicheroSrv = System.getProperty("mc") != null ? new ValidarLeerFicheroSrvImpl() : PRET_C170_Factory.getValidarFicheroSrv();
        validaFicheroSrv.inicializaValidador();
        FileInputStream fiso = null;
        FileInputStream fisi = null;
        if (this.validarEsquema(xml, validaFicheroSrv)) {
            PerceptorBean per = retencionesSrv.createPerceptorBean();
            try {
                fiso = new FileInputStream(xml);
                fisi = new FileInputStream(xml);
                validaFicheroSrv.prepararReaderRetenedor(fiso, per, false, true);
                validaFicheroSrv.prepararReaderRetenido(fisi, per, false, true);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            int numeroRetenedoresTotal = validaFicheroSrv.getNumeroRetenedoresTotal();
            int[] numeroRetenidosRetenedor = validaFicheroSrv.getListaRetenidos();
            int i = 0;
            while (i < numeroRetenedoresTotal) {
                this.getSiguienteRetenedor(xml, validaFicheroSrv, per);
                PerceptorBean perceptorActual = null;
                int j = 0;
                while (j < numeroRetenidosRetenedor[i]) {
                    perceptorActual = this.getSiguientePerceptor(xml, validaFicheroSrv, per);
                    boolean valido = retencionesSrv.validar(perceptorActual, true);
                    if (valido) {
                        retencionesSrv.calcular(perceptorActual);
                        valido = retencionesSrv.validarPostCalculos(perceptorActual);
                        if (valido && !this.huboErroresAntes) {
                            this.generarXMLSalida(perceptorActual, validaFicheroSrv);
                        } else {
                            this.huboErroresAntes = true;
                            if (!this.cerradaSalidaPorError) {
                                if (this.abiertoRetenedor) {
                                    validaFicheroSrv.terminaRetenedor();
                                    this.abiertoRetenedor = false;
                                }
                                validaFicheroSrv.terminarDocumento();
                                this.cerradaSalidaPorError = true;
                            }
                            if (retencionesSrv.getErrores(perceptorActual).size() > 0) {
                                validaFicheroSrv.crearFicheroErrorRetenidoSTAX(retencionesSrv, perceptorActual, this.indiceRetenedor, this.indiceRetenido);
                                this.abiertoRetenedor = true;
                            }
                        }
                    } else if (retencionesSrv.getErrores(perceptorActual).size() > 0 || !valido) {
                        this.huboErroresAntes = true;
                        if (!this.cerradaSalidaPorError) {
                            if (this.abiertoRetenedor) {
                                validaFicheroSrv.terminaRetenedor();
                                this.abiertoRetenedor = false;
                            }
                            validaFicheroSrv.terminarDocumento();
                            this.cerradaSalidaPorError = true;
                        }
                        if (retencionesSrv.getErrores(perceptorActual).size() > 0) {
                            validaFicheroSrv.crearFicheroErrorRetenidoSTAX(retencionesSrv, perceptorActual, this.indiceRetenedor, this.indiceRetenido);
                            this.abiertoRetenedor = true;
                        }
                    }
                    ++this.indiceRetenido;
                    ++j;
                }
                if (!this.huboErroresAntes) {
                    if (this.abiertoRetenedor) {
                        validaFicheroSrv.terminaRetenedor();
                        this.abiertoRetenedor = false;
                    }
                } else if (this.abiertoRetenedor) {
                    validaFicheroSrv.terminaRetenedorError();
                    this.abiertoRetenedor = false;
                }
                ++this.indiceRetenedor;
                this.indiceRetenido = 0;
                perceptorActual = null;
                ++i;
            }
            if (!this.huboErroresAntes) {
                validaFicheroSrv.terminarDocumento();
                validaFicheroSrv.ponerSello();
            } else {
                validaFicheroSrv.terminarDocumentoError();
            }
            per = null;
        }
        this.numRetenidos = validaFicheroSrv.getNumeroRetenidosTotal();
        this.numRetenedores = validaFicheroSrv.getNumeroRetenedoresTotal();
        this.ficheroSalida = validaFicheroSrv.salidaXML(this.huboErroresAntes);
        String salida = validaFicheroSrv.salidaXML(this.huboErroresAntes).getAbsolutePath();
        try {
            if (fiso != null) {
                fiso.close();
                fiso = null;
            }
            if (fisi != null) {
                fisi.close();
                fisi = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        validaFicheroSrv.cerrarReaderRetenedor();
        validaFicheroSrv.cerrarReaderRetenido();
        validaFicheroSrv.inicializaValidador();
        return salida;
    }

    private void generarXMLSalida(PerceptorBean perceptorActual, ValidarLeerFicheroSrv validaFicheroSrv) {
        this.cerradaSalidaPorError = false;
        if (this.indiceRetenedor == 0 && this.indiceRetenido == 0) {
            validaFicheroSrv.empiezaDocumento(perceptorActual);
        }
        if (this.indiceRetenido == 0) {
            this.abiertoRetenedor = true;
            validaFicheroSrv.empiezaRetenedor();
        }
        validaFicheroSrv.empiezaRetenido();
    }

    private PerceptorBean getSiguientePerceptor(File xml, ValidarLeerFicheroSrv validaFicheroSrv, PerceptorBean per) {
        validaFicheroSrv.leeRetenido(this.indiceRetenedor, this.indiceRetenido);
        return per;
    }

    private RetenedorBeanImpl getSiguienteRetenedor(File xml, ValidarLeerFicheroSrv validaFicheroSrv, PerceptorBean per) {
        validaFicheroSrv.leeRetenedor(this.indiceRetenedor);
        RetenedorBeanImpl re = new RetenedorBeanImpl();
        re.setNif((String)per.getValor("NIFRET"));
        re.setNombre((String)per.getValor("APERET"));
        return re;
    }

    private boolean validarEsquema(File xml, ValidarLeerFicheroSrv validaFicheroSrv) {
        validaFicheroSrv.validaXmlEntradaParaCalculos(xml.getPath());
        if (!validaFicheroSrv.isOk()) {
            this.errorValidacion = true;
        }
        return !this.errorValidacion;
    }

    @Override
    public Integer getNumeroRetenedores() {
        return this.numRetenedores;
    }

    @Override
    public Integer getNumeroRetenidos() {
        return this.numRetenidos;
    }

    @Override
    public Boolean getErrorCalculo() {
        if (!(this.errorValidacion || this.huboErroresAntes || this.cerradaSalidaPorError)) {
            return false;
        }
        return true;
    }

    @Override
    public File getSalida() {
        return this.ficheroSalida;
    }

    class RetenedorBeanImpl {
        String nif;
        String nombre;

        RetenedorBeanImpl() {
        }

        public String getNif() {
            return this.nif;
        }

        public void setNif(String nif) {
            this.nif = nif;
        }

        public String getNombre() {
            return this.nombre;
        }

        public void setNombre(String nombre) {
            this.nombre = nombre;
        }
    }
}

