/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c170.mc;

import es.aeat.pret.c170.imp.srv.CalculoRetencionesXMLSrvImpl;
import es.aeat.pret.c170.mc.AnalizarLineaComandoException;
import es.aeat.pret.c170.mc.AnalizarLineaComandos;
import es.aeat.pret.c170.mc.PathTrabajo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ResourceBundle;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ModuloCalculo {
    private static Logger logger = null;

    private ModuloCalculo() {
    }

    public static void procesarFicheroXml(String fichero, String errores, String flag, String salida) {
        block17: {
            System.setProperty("mc", "true");
            if (logger == null) {
                logger = LoggerFactory.getLogger(ModuloCalculo.class);
            }
            new File(errores).delete();
            new File(salida).delete();
            if (!new File(fichero).exists()) {
                try {
                    ModuloCalculo.generarErrorEntradaNoExiste(new File(errores));
                }
                catch (FileNotFoundException e) {
                    logger.error("Imposible crear fichero de errores.");
                }
                return;
            }
            CalculoRetencionesXMLSrvImpl mod = null;
            String copiaEntrada = null;
            String pathResultado = null;
            try {
                try {
                    copiaEntrada = ModuloCalculo.copyFile(fichero, null);
                    mod = new CalculoRetencionesXMLSrvImpl();
                    pathResultado = mod.procesar(new File(copiaEntrada));
                    if (pathResultado.contains("SRET")) {
                        new File(salida).delete();
                        ModuloCalculo.copyFile(pathResultado, salida);
                    } else {
                        new File(errores).delete();
                        ModuloCalculo.copyFile(pathResultado, errores);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (copiaEntrada != null) {
                        new File(copiaEntrada).delete();
                    }
                    if (pathResultado != null) {
                        new File(pathResultado).delete();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (copiaEntrada != null) {
                    new File(copiaEntrada).delete();
                }
                if (pathResultado != null) {
                    new File(pathResultado).delete();
                }
                throw throwable;
            }
            if (copiaEntrada != null) {
                new File(copiaEntrada).delete();
            }
            if (pathResultado != null) {
                new File(pathResultado).delete();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static String procesarFicheroXML(String entradaXML) throws SAXException, IOException {
        System.setProperty("mc", "true");
        if (logger == null) {
            logger = LoggerFactory.getLogger(ModuloCalculo.class);
        }
        Channel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        CalculoRetencionesXMLSrvImpl mod = null;
        File dest = null;
        String pathResultado = null;
        dest = File.createTempFile("stringfile-", null);
        destChannel = new FileOutputStream(dest).getChannel();
        byte[] bytesEntrada = entradaXML.getBytes();
        sourceChannel = Channels.newChannel(new ByteArrayInputStream(bytesEntrada));
        ((FileChannel)destChannel).transferFrom((ReadableByteChannel)sourceChannel, 0L, bytesEntrada.length);
        mod = new CalculoRetencionesXMLSrvImpl();
        pathResultado = mod.procesar(dest);
        String string = ModuloCalculo.fileToString(pathResultado);
        sourceChannel.close();
        destChannel.close();
        if (dest != null) {
            dest.delete();
        }
        if (pathResultado != null) {
            new File(pathResultado).delete();
        }
        return string;
        {
            catch (Exception e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    sourceChannel.close();
                    destChannel.close();
                    if (dest != null) {
                        dest.delete();
                    }
                    if (pathResultado != null) {
                        new File(pathResultado).delete();
                    }
                    throw throwable;
                }
            }
        }
        sourceChannel.close();
        destChannel.close();
        if (dest != null) {
            dest.delete();
        }
        if (pathResultado != null) {
            new File(pathResultado).delete();
        }
        return null;
    }

    private static void generarErrorEntradaNoExiste(File errores) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(errores);
        writer.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");
        writer.println("<AEATRetencionesError2017>");
        writer.println("<ErrorGeneral>");
        writer.println("<Linea>0</Linea>");
        writer.println("<Posicion>0</Posicion>");
        writer.println("<Descripcion>El fichero de entrada no existe.</Descripcion>");
        writer.println("</ErrorGeneral>");
        writer.println("</AEATRetencionesError2017>");
        writer.flush();
        writer.close();
    }

    private static String fileToString(String origen) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        Channel destChannel = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            File source = new File(origen);
            sourceChannel = new FileInputStream(source).getChannel();
            destChannel = Channels.newChannel(baos);
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            while (((FileChannel)sourceChannel).read(buffer) != -1) {
                buffer.flip();
                destChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                destChannel.write(buffer);
            }
            String string = baos.toString();
            return string;
        }
        finally {
            sourceChannel.close();
            destChannel.close();
        }
    }

    private static String copyFile(String origen, String destino) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            File dest;
            File source = new File(origen);
            sourceChannel = new FileInputStream(source).getChannel();
            if (destino == null) {
                dest = File.createTempFile("copyOf-" + source.getName() + "-", null);
                dest.deleteOnExit();
            } else {
                dest = new File(destino);
            }
            destChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)destChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
            String string = dest.getPath();
            return string;
        }
        finally {
            sourceChannel.close();
            destChannel.close();
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        System.setProperty("mc", "true");
        ModuloCalculo.configLog();
        logger = LoggerFactory.getLogger(ModuloCalculo.class);
        AnalizarLineaComandos alc = new AnalizarLineaComandos();
        alc.setParametro("E", true, null, true);
        alc.setParametro("R", true, null, true);
        alc.setParametro("S", true, null, true);
        alc.setParametro("I", false, "null", false);
        String fichero = null;
        try {
            alc.parse(args);
            fichero = alc.getParametro("E");
            String errores = alc.getParametro("R");
            String flag = "";
            String salida = alc.getParametro("S");
            String adicional = alc.getParametro("I");
            if (!adicional.equals("null")) {
                ResourceBundle bundle = ResourceBundle.getBundle("es/aeat/pret/c170/mc/retenciones");
                System.out.println(String.valueOf(bundle.getString("acercade.titulo")) + " " + bundle.getString("version.mc"));
            }
            ModuloCalculo.procesarFicheroXml(fichero, errores, flag, salida);
        }
        catch (AnalizarLineaComandoException ex) {
            logger.error("Error en l\u00ednea de comandos", (Throwable)ex);
            System.exit(1);
        }
    }

    private static void configLog() {
        try {
            LogManager logManager = LogManager.getLogManager();
            InputStream prop = ModuloCalculo.class.getResourceAsStream("/es/aeat/pret/rd15/julio/recursos/logging.properties");
            logManager.readConfiguration(prop);
            prop.close();
            File file = new File(PathTrabajo.getPathTrabajoSinProtocolo(), "slf4j-jdk14-1.6.1.jar");
            if (file.exists()) {
                ModuloCalculo.addURL(file.toURI().toURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

