/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c200.c211.imp.srv;

import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.c211.api.PRET_C211_Factory;
import es.aeat.pret.c200.c211.api.srv.CalculoRetencionesSrv;
import es.aeat.pret.c200.c211.api.srv.CalculoRetencionesXMLSrv;
import es.aeat.pret.c200.c211.api.srv.ValidarLeerFicheroSrv;
import es.aeat.pret.c200.c211.imp.srv.CalculoRetencionesSrvImpl;
import es.aeat.pret.c200.c211.imp.srv.ValidarLeerFicheroSrvImpl;
import es.aeat.pret.c200.imp.bean.PerceptorBeanImpl;
import es.aeat.pret.c200.mc.ModuloCalculo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

public class CalculoRetencionesXMLSrvImpl
implements CalculoRetencionesXMLSrv {
    private Logger getLog() {
        return Logger.getLogger(PerceptorBeanImpl.class.getName());
    }

    @Override
    public String procesar(File xml, PerceptorBean perceptor) {
        CalculoRetencionesSrv retencionesSrv = ModuloCalculo.isModuloCalculo() ? new CalculoRetencionesSrvImpl() : PRET_C211_Factory.getCalculoRetencionesSrv();
        ValidarLeerFicheroSrv validaFicheroSrv = ModuloCalculo.isModuloCalculo() ? new ValidarLeerFicheroSrvImpl() : PRET_C211_Factory.getValidarFicheroSrv();
        PerceptorBean per = ModuloCalculo.isModuloCalculo() ? retencionesSrv.createPerceptorBean() : perceptor;
        PerceptorBean controla = retencionesSrv.createPerceptorBean();
        per.setCerradaSalidaPorError(true);
        per.setHuboErroresAntes(false);
        per.setErrorValidacion(false);
        per.setIndiceRetenedor(0);
        per.setIndiceRetenido(0);
        per.setFicheroSalidaCalculo(null);
        validaFicheroSrv.inicializaValidador(per);
        FileInputStream fiso = null;
        FileInputStream fisi = null;
        int numeroRetenedoresTotal = 0;
        int numeroRetenidosTotal = 0;
        if (this.validarEsquema(xml, validaFicheroSrv, per)) {
            if (numeroRetenedoresTotal == 0 && numeroRetenidosTotal == 0) {
                controla.setFicheroError(per.getFicheroError());
                controla.setFicheroSalida(per.getFicheroSalida());
                controla.setFicheroSalidaCalculo(per.getFicheroSalidaCalculo());
            }
            try {
                fiso = new FileInputStream(xml);
                fisi = new FileInputStream(xml);
                validaFicheroSrv.prepararReaderRetenedor(fiso, per, false, true, false);
                validaFicheroSrv.prepararReaderRetenido(fisi, per, false, true, false);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            controla.setIndiceRetenedor(0);
            controla.setIndiceRetenido(0);
            numeroRetenedoresTotal = validaFicheroSrv.getNumeroRetenedoresTotal(per);
            int[] numeroRetenidosRetenedor = validaFicheroSrv.getListaRetenidos(per);
            int i = 0;
            while (i < numeroRetenedoresTotal) {
                per.setIndiceRetenedor(controla.getIndiceRetenedor());
                this.getSiguienteRetenedor(validaFicheroSrv, per);
                int j = 0;
                while (j < numeroRetenidosRetenedor[i]) {
                    ++numeroRetenidosTotal;
                    per.setIndiceRetenedor(controla.getIndiceRetenedor());
                    per.setIndiceRetenido(controla.getIndiceRetenido());
                    this.getSiguientePerceptor(validaFicheroSrv, per);
                    per.setIndiceRetenedor(controla.getIndiceRetenedor());
                    per.setIndiceRetenido(controla.getIndiceRetenido());
                    boolean valido = retencionesSrv.validar(per, true);
                    if (valido) {
                        retencionesSrv.calcular(per);
                        valido = retencionesSrv.validarPostCalculos(per);
                        if (valido && !controla.isHuboErroresAntes()) {
                            this.generarXMLSalida(per, validaFicheroSrv);
                            if (per.getIndiceRetenido() == 0) {
                                controla.setAbiertoRetenedor(true);
                            }
                        } else {
                            controla.setHuboErroresAntes(true);
                            if (!controla.isCerradaSalidaPorError()) {
                                if (controla.isAbiertoRetenedor()) {
                                    validaFicheroSrv.terminaRetenedor(per);
                                    controla.setAbiertoRetenedor(false);
                                }
                                if (per.getStax() != null) {
                                    validaFicheroSrv.terminarDocumento(per);
                                }
                                controla.setCerradaSalidaPorError(true);
                            }
                            if (!retencionesSrv.getErrores(per).isEmpty()) {
                                validaFicheroSrv.crearFicheroErrorRetenidoSTAX(retencionesSrv, per, controla.getIndiceRetenedor(), controla.getIndiceRetenido());
                                controla.setAbiertoRetenedor(true);
                            }
                        }
                    } else if (!retencionesSrv.getErrores(per).isEmpty() || !valido) {
                        controla.setHuboErroresAntes(true);
                        if (!controla.isCerradaSalidaPorError()) {
                            if (controla.isAbiertoRetenedor()) {
                                validaFicheroSrv.terminaRetenedor(per);
                                controla.setAbiertoRetenedor(false);
                            }
                            if (per.getStax() != null) {
                                validaFicheroSrv.terminarDocumento(per);
                            }
                            controla.setCerradaSalidaPorError(true);
                        }
                        if (!retencionesSrv.getErrores(per).isEmpty()) {
                            validaFicheroSrv.crearFicheroErrorRetenidoSTAX(retencionesSrv, per, controla.getIndiceRetenedor(), controla.getIndiceRetenido());
                            controla.setAbiertoRetenedor(true);
                        }
                    }
                    int indiceRetenido = controla.getIndiceRetenido() + 1;
                    controla.setIndiceRetenido(indiceRetenido);
                    ++j;
                }
                if (!controla.isHuboErroresAntes()) {
                    if (controla.isAbiertoRetenedor()) {
                        validaFicheroSrv.terminaRetenedor(per);
                        controla.setAbiertoRetenedor(false);
                    }
                } else if (controla.isAbiertoRetenedor()) {
                    validaFicheroSrv.terminaRetenedorError(per);
                    controla.setAbiertoRetenedor(false);
                }
                controla.setIndiceRetenedor(controla.getIndiceRetenedor() + 1);
                controla.setIndiceRetenido(0);
                ++i;
            }
            numeroRetenidosRetenedor = null;
            if (!controla.isHuboErroresAntes()) {
                validaFicheroSrv.terminarDocumento(per);
                validaFicheroSrv.ponerSello(per);
            } else {
                validaFicheroSrv.terminarDocumentoError(per);
            }
            if (!controla.isHuboErroresAntes()) {
                controla.setFicheroSalidaCalculo(per.getFicheroSalida());
            } else {
                controla.setFicheroSalidaCalculo(per.getFicheroError());
            }
        } else {
            controla.setFicheroSalidaCalculo(per.getFicheroError());
        }
        controla.setFicheroError(per.getFicheroError());
        controla.setFicheroSalida(per.getFicheroSalida());
        controla.setErrorImportacion(per.isErrorImportacion());
        controla.setErrorValidacion(per.isErrorValidacion());
        controla.setErroresImportacion(per.getErroresImportacion());
        controla.setTenemosError(per.isTenemosError());
        String salida = validaFicheroSrv.salidaXML(controla.isHuboErroresAntes(), controla).getAbsolutePath();
        try {
            if (fiso != null) {
                fiso.close();
                fiso = null;
            }
            if (fisi != null) {
                fisi.close();
                fisi = null;
            }
        }
        catch (IOException e) {
            this.getLog().severe(e.getMessage());
        }
        validaFicheroSrv.cerrarReaderRetenedor(per);
        validaFicheroSrv.cerrarReaderRetenido(per);
        validaFicheroSrv.inicializaValidador(per);
        validaFicheroSrv = null;
        retencionesSrv = null;
        if (perceptor == null) {
            controla.borraDatos();
            controla = null;
            per.borraDatos();
            per = null;
        } else {
            per.borraDatos();
            per = null;
            perceptor.setFicheroError(controla.getFicheroError());
            perceptor.setFicheroSalida(controla.getFicheroSalida());
            perceptor.setFicheroSalidaCalculo(controla.getFicheroSalidaCalculo());
            perceptor.setNumeroRetenedoresCalculo(numeroRetenedoresTotal);
            perceptor.setNumeroRetenidosCalculo(numeroRetenidosTotal);
            perceptor.setHuboErroresAntes(controla.isHuboErroresAntes());
            perceptor.setCerradaSalidaPorError(controla.isCerradaSalidaPorError());
            perceptor.setErrorImportacion(controla.isErrorImportacion());
            perceptor.setErrorValidacion(controla.isErrorValidacion());
            perceptor.setTenemosError(controla.isTenemosError());
            controla.borraDatos();
            controla = null;
        }
        return salida;
    }

    private void generarXMLSalida(PerceptorBean perceptorActual, ValidarLeerFicheroSrv validaFicheroSrv) {
        perceptorActual.setCerradaSalidaPorError(false);
        if (perceptorActual.getIndiceRetenedor() == 0 && perceptorActual.getIndiceRetenido() == 0) {
            validaFicheroSrv.empiezaDocumento(perceptorActual);
        }
        if (perceptorActual.getIndiceRetenido() == 0) {
            validaFicheroSrv.empiezaRetenedor(perceptorActual);
        }
        validaFicheroSrv.empiezaRetenido(perceptorActual);
    }

    private void getSiguientePerceptor(ValidarLeerFicheroSrv validaFicheroSrv, PerceptorBean per) {
        validaFicheroSrv.leeRetenido(per.getIndiceRetenedor(), per.getIndiceRetenido(), per);
    }

    private void getSiguienteRetenedor(ValidarLeerFicheroSrv validaFicheroSrv, PerceptorBean per) {
        validaFicheroSrv.leeRetenedor(per.getIndiceRetenedor(), per);
    }

    private boolean validarEsquema(File xml, ValidarLeerFicheroSrv validaFicheroSrv, PerceptorBean per) {
        validaFicheroSrv.validaXmlEntradaParaCalculos(xml.getPath(), per);
        if (!validaFicheroSrv.isOk(per)) {
            per.setErrorValidacion(true);
        }
        return !per.isErrorValidacion();
    }

    @Override
    public Integer getNumeroRetenedores(PerceptorBean per) {
        return per.getNumeroRetenedoresCalculo();
    }

    @Override
    public Integer getNumeroRetenidos(PerceptorBean per) {
        return per.getNumeroRetenidosCalculo();
    }

    @Override
    public Boolean getErrorCalculo(PerceptorBean per) {
        if (!(per.isErrorValidacion() || per.isHuboErroresAntes() || per.isCerradaSalidaPorError())) {
            return false;
        }
        return true;
    }

    @Override
    public File getSalida(PerceptorBean per) {
        return per.getFicheroSalidaCalculo();
    }

    class RetenedorBeanImpl {
        String nif;
        String nombre;

        RetenedorBeanImpl() {
        }

        public String getNif() {
            return this.nif;
        }

        public void setNif(String nif) {
            this.nif = nif;
        }

        public String getNombre() {
            return this.nombre;
        }

        public void setNombre(String nombre) {
            this.nombre = nombre;
        }
    }
}

