/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c200.c211.util;

import es.aeat.pret.c200.api.bean.AscendienteBean;
import es.aeat.pret.c200.api.bean.DescendienteBean;
import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.api.staxi.ILeeRetenido;
import es.aeat.pret.c200.imp.bean.PerceptorBeanImpl;
import es.aeat.pret.c200.util.NombreNif;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class LeeRetenido
implements ILeeRetenido {
    private static final long serialVersionUID = 1L;
    private XMLInputFactory factory = null;
    private final HashMap<String, Element> nameToTypeMapping = new HashMap();
    private StringBuilder currentText;
    private Element currentElement;
    private PerceptorBean modelo = null;
    private ArrayList<NombreNif> lista = null;
    private NombreNif retenido;
    String nif;
    ArrayList<Integer> causas = null;
    int tipoRetiDescAsc = 0;
    List<DescendienteBean> datosDescendientes = null;
    List<AscendienteBean> datosAscendientes = null;
    DescendienteBean descend = null;
    AscendienteBean ascend = null;
    int indiceRetenedorALeer;
    int indiceRetenedorLeido = -1;
    int indiceRetenidoALeer;
    int indiceRetenidoLeido = -1;
    boolean estamosRetenido = false;
    XMLStreamReader xmlReader = null;
    boolean importarXML = false;
    boolean buscarRetenido = false;
    boolean retenidoEncontrado = false;
    boolean soloLeer = false;

    public LeeRetenido() {
        this.nameToTypeMapping.put("Nif", Element.NIF);
        this.nameToTypeMapping.put("ApellidosNombre", Element.APELLIDOSNOMBRE);
        this.nameToTypeMapping.put("A\u00f1oNacimiento", Element.ANIONACIMIENTO);
        this.nameToTypeMapping.put("comunidadAutonoma", Element.COMUNIDADAUTONOMA);
        this.nameToTypeMapping.put("ResidenciaCeutaMelilla", Element.RESIDENCIACEUTAMELILLA);
        this.nameToTypeMapping.put("Situacion1", Element.SITUACION1);
        this.nameToTypeMapping.put("Situacion2", Element.SITUACION2);
        this.nameToTypeMapping.put("NifConyuge", Element.NIFCONYUGE);
        this.nameToTypeMapping.put("Situacion3", Element.SITUACION3);
        this.nameToTypeMapping.put("Grado1", Element.GRADO1);
        this.nameToTypeMapping.put("Grado2", Element.GRADO2);
        this.nameToTypeMapping.put("MovilidadReducida", Element.MOVILIDADREDUCIDA);
        this.nameToTypeMapping.put("TrabajadorActivo", Element.TRABAJADORACTIVO);
        this.nameToTypeMapping.put("Desempleado", Element.DESEMPLEADO);
        this.nameToTypeMapping.put("Pensionista", Element.PENSIONISTA);
        this.nameToTypeMapping.put("OtraSituacion", Element.OTRASITUACION);
        this.nameToTypeMapping.put("Contrato", Element.CONTRATO);
        this.nameToTypeMapping.put("MovilidadGeografica", Element.MOVILIDADGEOGRAFICA);
        this.nameToTypeMapping.put("Descendiente", Element.DESCENDIENTE);
        this.nameToTypeMapping.put("Ascendiente", Element.ASCENDIENTE);
        this.nameToTypeMapping.put("A\u00f1oAdopcion", Element.ANIOADOPCION);
        this.nameToTypeMapping.put("ComputadoEntero", Element.COMPUTADOENTERO);
        this.nameToTypeMapping.put("Convivencia", Element.CONVIVENCIA);
        this.nameToTypeMapping.put("RetribAnuales", Element.RETRIBANUALES);
        this.nameToTypeMapping.put("Retenido", Element.RETENIDO);
        this.nameToTypeMapping.put("Retenedor", Element.RETENEDOR);
        this.nameToTypeMapping.put("Irregularidad1", Element.IRREGULARIDAD1);
        this.nameToTypeMapping.put("Irregularidad2", Element.IRREGULARIDAD2);
        this.nameToTypeMapping.put("Cotizaciones", Element.COTIZACIONES);
        this.nameToTypeMapping.put("PensionCompensatoria", Element.PENSIONCOMPENSATORIA);
        this.nameToTypeMapping.put("AnualidadesHijos", Element.ANUALIDADESHIJOS);
        this.nameToTypeMapping.put("RdtosObtenidosCeutaMelilla", Element.RDTOSOBTENIDOSCEUTAMELILLA);
        this.nameToTypeMapping.put("PagoPrestamosVivienda", Element.PAGOPRESTAMOSVIVIENDA);
        this.nameToTypeMapping.put("Causa", Element.CAUSA);
        this.nameToTypeMapping.put("RetribSatisfechas", Element.RETRIBSATISFECHAS);
        this.nameToTypeMapping.put("RetencionPracticada", Element.RETENCIONPRACTICADA);
        this.nameToTypeMapping.put("RetribAnualesIniciales", Element.RETRIBANUALESINICIALES);
        this.nameToTypeMapping.put("RetencionAnualInicial", Element.RETENCIONANUALINICIAL);
        this.nameToTypeMapping.put("ResidenciaInicialCeutaMelilla", Element.RESIDENCIAINICIALCEUTAMELILLA);
        this.nameToTypeMapping.put("MinimoPersonalFamiliarInicial", Element.MINIMOPERSONALFAMILIARINICIAL);
        this.nameToTypeMapping.put("BaseRetencion", Element.BASERETENCION);
        this.nameToTypeMapping.put("TipoRetencion", Element.TIPORETENCION);
        this.nameToTypeMapping.put("MinoracionPrestamosVivienda", Element.MINORACIONPRESTAMOSVIVIENDA);
        this.nameToTypeMapping.put("AEATRetencionesEntrada2021", Element.AEATRETENCIONESENTRADA2021);
        this.nameToTypeMapping.put("IdDoc", Element.IDDOC);
        this.nameToTypeMapping.put("CodModelo", Element.CODMODELO);
        this.nameToTypeMapping.put("Ejercicio", Element.EJERCICIO);
    }

    @Override
    public void preparamosLectura() {
        this.indiceRetenedorLeido = -1;
        this.indiceRetenidoLeido = -1;
    }

    @Override
    public void crearXMLReader(FileInputStream input, PerceptorBean modelo, boolean importarXML, boolean buscarRetenido, boolean soloLeer) throws XMLStreamException {
        if (this.factory == null) {
            this.factory = XMLInputFactory.newInstance();
            this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this.factory.setProperty("javax.xml.stream.supportDTD", false);
        }
        if (this.xmlReader == null) {
            this.xmlReader = this.factory.createXMLStreamReader(input);
        }
        this.modelo = modelo;
        this.importarXML = importarXML;
        this.buscarRetenido = buscarRetenido;
        this.soloLeer = soloLeer;
    }

    @Override
    public void borrarLista() {
        if (this.lista != null) {
            this.lista = null;
        }
    }

    @Override
    public void cerrarReader() {
        try {
            if (this.lista != null) {
                this.lista = null;
            }
            if (this.xmlReader != null) {
                this.xmlReader.close();
                this.xmlReader = null;
            }
            this.modelo = null;
            this.factory = null;
        }
        catch (XMLStreamException e) {
            this.getLog().severe(e.getMessage());
        }
    }

    @Override
    public void readXml(int indiceRetenedor, int indiceRetenido) throws XMLStreamException {
        this.indiceRetenedorALeer = indiceRetenedor;
        this.indiceRetenidoALeer = indiceRetenido;
        while (this.xmlReader.hasNext()) {
            int eventType = this.xmlReader.next();
            switch (eventType) {
                case 4: {
                    this.processText(this.xmlReader.getText());
                    break;
                }
                case 2: {
                    if (!this.ended(this.xmlReader.getLocalName())) break;
                    return;
                }
                case 1: {
                    this.startElement(this.xmlReader.getLocalName());
                    break;
                }
            }
        }
    }

    @Override
    public List<String> getLista() {
        if (this.lista == null) {
            return null;
        }
        ArrayList<String> hm = new ArrayList<String>();
        int numl = this.lista.size();
        int i = 0;
        while (i < numl) {
            NombreNif nn = this.lista.get(i);
            hm.add(String.valueOf(nn.getNombre()) + "-" + nn.getNif());
            ++i;
        }
        return hm;
    }

    @Override
    public boolean encontrado() {
        return this.retenidoEncontrado;
    }

    private void processText(String text) {
        if (this.currentElement != null && this.currentText != null) {
            this.currentText.append(text);
        }
    }

    private void startElement(String localName) throws XMLStreamException {
        this.currentElement = this.nameToTypeMapping.get(localName);
        this.currentText = new StringBuilder(256);
        if (this.currentElement == Element.AEATRETENCIONESENTRADA2021 || this.currentElement == Element.IDDOC || this.currentElement == Element.CODMODELO || this.currentElement == Element.EJERCICIO) {
            return;
        }
        if (this.soloLeer) {
            if (this.currentElement == Element.RETENEDOR) {
                this.estamosRetenido = false;
                ++this.indiceRetenedorLeido;
                this.indiceRetenidoLeido = -1;
                if (this.indiceRetenedorALeer == this.indiceRetenedorLeido) {
                    this.lista = new ArrayList();
                }
                return;
            }
            if (this.currentElement == Element.RETENIDO) {
                if (this.buscarRetenido) {
                    ++this.indiceRetenidoLeido;
                }
                this.estamosRetenido = true;
                this.retenido = new NombreNif();
                return;
            }
            return;
        }
        if (this.currentElement == Element.RETENEDOR) {
            this.estamosRetenido = false;
            ++this.indiceRetenedorLeido;
            this.indiceRetenidoLeido = -1;
            return;
        }
        if (this.currentElement == Element.RETENIDO) {
            this.estamosRetenido = true;
            this.retenido = new NombreNif();
            ++this.indiceRetenidoLeido;
            String nifRete = (String)this.modelo.getValor("nifret");
            String nombreRete = (String)this.modelo.getValor("aperet");
            this.modelo.borraDatos();
            this.modelo.setValor("nifret", nifRete);
            this.modelo.setValor("aperet", nombreRete);
            return;
        }
        if (this.indiceRetenedorALeer != this.indiceRetenedorLeido || this.indiceRetenidoALeer != this.indiceRetenidoLeido) {
            return;
        }
        if (this.currentElement == Element.NIF) {
            this.retenidoEncontrado = true;
            if (this.estamosRetenido) {
                this.tipoRetiDescAsc = 1;
            }
            return;
        }
        if (this.currentElement == Element.DESCENDIENTE) {
            this.tipoRetiDescAsc = 2;
            this.descend = this.modelo.createDescendienteBean();
            this.datosDescendientes = this.modelo.getDescendientes();
            return;
        }
        if (this.currentElement == Element.ASCENDIENTE) {
            this.tipoRetiDescAsc = 3;
            this.ascend = this.modelo.createAscendienteBean();
            this.datosAscendientes = this.modelo.getAscendientes();
            return;
        }
        if (this.currentElement == Element.ANIONACIMIENTO) {
            if (this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                if (this.tipoRetiDescAsc == 2) {
                    this.descend.setAnioAdopcion(0);
                    this.descend.setPorEntero(false);
                    this.descend.setDiscapacidad(0);
                    this.descend.setMovilidadReducida(false);
                } else if (this.tipoRetiDescAsc == 3) {
                    this.ascend.setConvivencia(0);
                    this.ascend.setDiscapacidad(0);
                    this.ascend.setMovilidadReducida(false);
                }
            }
            return;
        }
        if (this.currentElement == Element.GRADO1) {
            if (this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                if (this.tipoRetiDescAsc == 1) {
                    this.modelo.setValor("movilper", "0");
                }
                if (this.tipoRetiDescAsc == 2) {
                    this.descend.setDiscapacidad(0);
                }
                if (this.tipoRetiDescAsc == 3) {
                    this.ascend.setDiscapacidad(0);
                }
            }
            return;
        }
        if (this.currentElement == Element.TRABAJADORACTIVO) {
            if (this.modelo != null && this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                this.modelo.setValor("movil", "0");
            }
            return;
        }
        if (this.currentElement == Element.RETRIBANUALES) {
            if (this.modelo != null && this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                this.modelo.setValor("renceme", "0");
                this.modelo.setValor("presviv", "0");
            }
            return;
        }
    }

    private boolean ended(String localName) {
        block67: {
            block69: {
                block68: {
                    this.currentElement = this.nameToTypeMapping.get(localName);
                    if (this.currentElement == null) break block67;
                    if (this.currentElement == Element.AEATRETENCIONESENTRADA2021 || this.currentElement == Element.IDDOC || this.currentElement == Element.CODMODELO || this.currentElement == Element.EJERCICIO) {
                        return false;
                    }
                    if (!this.soloLeer) break block68;
                    if (this.indiceRetenedorALeer != this.indiceRetenedorLeido) {
                        return false;
                    }
                    if (!("Nif".equalsIgnoreCase(this.currentElement.toString()) || "ApellidosNombre".equalsIgnoreCase(this.currentElement.toString()) || "Retenido".equalsIgnoreCase(this.currentElement.toString()) || "Retenedor".equalsIgnoreCase(this.currentElement.toString()))) {
                        return false;
                    }
                    switch (this.currentElement) {
                        case NIF: {
                            if (this.estamosRetenido) {
                                this.retenido.setNif(this.currentText.toString());
                                break;
                            }
                            break block69;
                        }
                        case APELLIDOSNOMBRE: {
                            if (this.estamosRetenido) {
                                this.retenido.setNombre(this.currentText.toString());
                                break;
                            }
                            break block69;
                        }
                        case RETENIDO: {
                            if (this.buscarRetenido && this.indiceRetenedorALeer == this.indiceRetenedorLeido && this.indiceRetenidoALeer == this.indiceRetenidoLeido) {
                                this.lista.add(this.retenido);
                            } else if (!this.buscarRetenido) {
                                this.lista.add(this.retenido);
                            }
                            this.estamosRetenido = false;
                            this.retenido = null;
                            break;
                        }
                        case RETENEDOR: {
                            return true;
                        }
                    }
                    break block69;
                }
                if (this.indiceRetenedorALeer != this.indiceRetenedorLeido || this.indiceRetenidoALeer != this.indiceRetenidoLeido) {
                    return false;
                }
                switch (this.currentElement) {
                    case NIF: {
                        this.modelo.setValor("nifper", this.currentText.toString());
                        break;
                    }
                    case APELLIDOSNOMBRE: {
                        if (!this.importarXML) {
                            this.modelo.setValor("apeper", this.currentText.toString());
                            break;
                        }
                        this.modelo.setValor("apeper", this.modelo.getValor("aperet"));
                        break;
                    }
                    case ANIONACIMIENTO: {
                        if (this.tipoRetiDescAsc == 1) {
                            this.modelo.setValor("anoper", this.currentText.toString().trim());
                            break;
                        }
                        if (this.tipoRetiDescAsc == 2) {
                            this.descend.setAnioNacimiento(Integer.parseInt(this.currentText.toString().trim()));
                            break;
                        }
                        if (this.tipoRetiDescAsc != 3) break;
                        this.ascend.setAnioNacimiento(Integer.parseInt(this.currentText.toString().trim()));
                        break;
                    }
                    case SITUACION1: {
                        this.modelo.setValor("situfam", "1");
                        break;
                    }
                    case SITUACION2: {
                        this.modelo.setValor("situfam", "2");
                        break;
                    }
                    case NIFCONYUGE: {
                        this.modelo.setValor("nifcon", this.currentText.toString());
                        break;
                    }
                    case SITUACION3: {
                        this.modelo.setValor("situfam", "3");
                        break;
                    }
                    case GRADO1: {
                        if (this.tipoRetiDescAsc == 1) {
                            this.modelo.setValor("discaper", "1");
                        }
                        if (this.tipoRetiDescAsc == 2) {
                            this.descend.setDiscapacidad(1);
                        }
                        if (this.tipoRetiDescAsc != 3) break;
                        this.ascend.setDiscapacidad(1);
                        break;
                    }
                    case GRADO2: {
                        if (this.tipoRetiDescAsc == 1) {
                            this.modelo.setValor("discaper", "2");
                        }
                        if (this.tipoRetiDescAsc == 2) {
                            this.descend.setDiscapacidad(2);
                        }
                        if (this.tipoRetiDescAsc != 3) break;
                        this.ascend.setDiscapacidad(2);
                        break;
                    }
                    case MOVILIDADREDUCIDA: {
                        if (this.tipoRetiDescAsc == 1) {
                            this.modelo.setValor("movilper", "1");
                        }
                        if (this.tipoRetiDescAsc == 2) {
                            this.descend.setMovilidadReducida(true);
                        }
                        if (this.tipoRetiDescAsc != 3) break;
                        this.ascend.setMovilidadReducida(true);
                        break;
                    }
                    case RESIDENCIACEUTAMELILLA: {
                        this.modelo.setValor("resiceme", "1");
                        break;
                    }
                    case TRABAJADORACTIVO: {
                        this.modelo.setValor("situper", "1");
                        break;
                    }
                    case DESEMPLEADO: {
                        this.modelo.setValor("situper", "3");
                        break;
                    }
                    case PENSIONISTA: {
                        this.modelo.setValor("situper", "2");
                        break;
                    }
                    case OTRASITUACION: {
                        this.modelo.setValor("situper", "4");
                        break;
                    }
                    case CONTRATO: {
                        this.modelo.setValor("contrato", this.currentText.toString().trim());
                        break;
                    }
                    case MOVILIDADGEOGRAFICA: {
                        this.modelo.setValor("movil", "1");
                        break;
                    }
                    case ANIOADOPCION: {
                        this.descend.setAnioAdopcion(Integer.parseInt(this.currentText.toString().trim()));
                        break;
                    }
                    case COMPUTADOENTERO: {
                        this.descend.setPorEntero(true);
                        break;
                    }
                    case CONVIVENCIA: {
                        this.ascend.setConvivencia(Integer.parseInt(this.currentText.toString().trim()));
                        break;
                    }
                    case DESCENDIENTE: {
                        this.datosDescendientes.add(this.descend);
                        break;
                    }
                    case ASCENDIENTE: {
                        this.datosAscendientes.add(this.ascend);
                        break;
                    }
                    case RETRIBANUALES: {
                        this.modelo.setValor("retrib", this.currentText.toString().trim());
                        break;
                    }
                    case IRREGULARIDAD1: {
                        this.modelo.setValor("irregular1", this.currentText.toString().trim());
                        break;
                    }
                    case IRREGULARIDAD2: {
                        this.modelo.setValor("irregular2", this.currentText.toString().trim());
                        break;
                    }
                    case COTIZACIONES: {
                        this.modelo.setValor("cotizaciones", this.currentText.toString().trim());
                        break;
                    }
                    case PENSIONCOMPENSATORIA: {
                        this.modelo.setValor("conyuge", this.currentText.toString().trim());
                        break;
                    }
                    case ANUALIDADESHIJOS: {
                        this.modelo.setValor("anualidades", this.currentText.toString().trim());
                        break;
                    }
                    case RDTOSOBTENIDOSCEUTAMELILLA: {
                        this.modelo.setValor("renceme", "1");
                        break;
                    }
                    case PAGOPRESTAMOSVIVIENDA: {
                        this.modelo.setValor("presviv", "1");
                        break;
                    }
                    case CAUSA: {
                        if (this.importarXML) break;
                        int indiceCausa = Integer.parseInt(this.currentText.toString().trim());
                        this.modelo.setValor("causa", true, indiceCausa);
                        break;
                    }
                    case RETRIBSATISFECHAS: {
                        if (this.importarXML) break;
                        this.modelo.setValor("percibido", this.currentText.toString().trim());
                        break;
                    }
                    case RETENCIONPRACTICADA: {
                        if (this.importarXML) break;
                        this.modelo.setValor("retenido", this.currentText.toString().trim());
                        break;
                    }
                    case RETRIBANUALESINICIALES: {
                        if (this.importarXML) break;
                        this.modelo.setValor("retriba", this.currentText.toString().trim());
                        break;
                    }
                    case RETENCIONANUALINICIAL: {
                        if (this.importarXML) break;
                        this.modelo.setValor("importea", this.currentText.toString().trim());
                        break;
                    }
                    case RESIDENCIAINICIALCEUTAMELILLA: {
                        if (this.importarXML) break;
                        this.modelo.setValor("rencemea", "1");
                        break;
                    }
                    case BASERETENCION: {
                        if (this.importarXML) break;
                        this.modelo.setValor("basea", this.currentText.toString().trim());
                        break;
                    }
                    case MINIMOPERSONALFAMILIARINICIAL: {
                        if (this.importarXML) break;
                        this.modelo.setValor("minperfaa", this.currentText.toString().trim());
                        break;
                    }
                    case TIPORETENCION: {
                        if (this.importarXML) break;
                        this.modelo.setValor("tipoa", this.currentText.toString().trim());
                        break;
                    }
                    case MINORACIONPRESTAMOSVIVIENDA: {
                        if (this.importarXML) break;
                        this.modelo.setValor("minorado", "1");
                        this.modelo.setValor("minopagoa", this.currentText.toString().trim());
                        break;
                    }
                    case RETENIDO: {
                        this.estamosRetenido = false;
                        this.datosAscendientes = null;
                        this.datosDescendientes = null;
                        this.descend = null;
                        this.causas = null;
                        return true;
                    }
                }
            }
            this.currentElement = null;
            this.currentText = null;
        }
        return false;
    }

    private Logger getLog() {
        return Logger.getLogger(PerceptorBeanImpl.class.getName());
    }

    private static enum Element {
        NIF,
        APELLIDOSNOMBRE,
        ANIONACIMIENTO,
        COMUNIDADAUTONOMA,
        RESIDENCIACEUTAMELILLA,
        SITUACION1,
        SITUACION2,
        NIFCONYUGE,
        SITUACION3,
        GRADO1,
        GRADO2,
        MOVILIDADREDUCIDA,
        TRABAJADORACTIVO,
        DESEMPLEADO,
        PENSIONISTA,
        OTRASITUACION,
        CONTRATO,
        MOVILIDADGEOGRAFICA,
        DESCENDIENTE,
        ASCENDIENTE,
        ANIOADOPCION,
        COMPUTADOENTERO,
        CONVIVENCIA,
        RETENIDO,
        RETENEDOR,
        RETRIBANUALES,
        IRREGULARIDAD1,
        IRREGULARIDAD2,
        COTIZACIONES,
        PENSIONCOMPENSATORIA,
        ANUALIDADESHIJOS,
        RDTOSOBTENIDOSCEUTAMELILLA,
        PAGOPRESTAMOSVIVIENDA,
        CAUSA,
        RETRIBSATISFECHAS,
        RETENCIONPRACTICADA,
        RETRIBANUALESINICIALES,
        RETENCIONANUALINICIAL,
        RESIDENCIAINICIALCEUTAMELILLA,
        MINIMOPERSONALFAMILIARINICIAL,
        BASERETENCION,
        TIPORETENCION,
        MINORACIONPRESTAMOSVIVIENDA,
        AEATRETENCIONESENTRADA2021,
        IDDOC,
        CODMODELO,
        EJERCICIO;

    }
}

