/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pret.c200.mc.c210;

import es.aeat.pret.c200.c210.imp.srv.CalculoRetencionesXMLSrvImpl;
import es.aeat.pret.c200.mc.comun.AnalizarLineaComandoException;
import es.aeat.pret.c200.mc.comun.AnalizarLineaComandos;
import es.aeat.pret.c200.mc.comun.PathTrabajo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuloCalculo {
    private static final String NO_SE_HA_BORRADO = "No se pudo borrar el fichero: %s";

    private ModuloCalculo() {
    }

    public static void procesarFicheroXml(String ficheroEntrada, String ficheroErrores, String flag, String ficheroSalida) {
        block10: {
            es.aeat.pret.c200.mc.ModuloCalculo.setModuloCalculo(true);
            ModuloCalculo.borrarFichero(ficheroErrores);
            ModuloCalculo.borrarFichero(ficheroSalida);
            File file = new File(ficheroEntrada);
            if (!file.exists()) {
                try {
                    ModuloCalculo.generarErrorEntradaNoExiste(file);
                }
                catch (FileNotFoundException e) {
                    ModuloCalculo.getLogger().error("Imposible crear fichero de errores.");
                }
                return;
            }
            CalculoRetencionesXMLSrvImpl modulo = null;
            String copiaEntrada = null;
            String pathResultado = null;
            try {
                try {
                    copiaEntrada = ModuloCalculo.copyFile(ficheroEntrada, null);
                    modulo = new CalculoRetencionesXMLSrvImpl();
                    pathResultado = modulo.procesar(new File(copiaEntrada), null);
                    if (pathResultado.contains("SRET")) {
                        ModuloCalculo.borrarFichero(ficheroSalida);
                        ModuloCalculo.copyFile(pathResultado, ficheroSalida);
                    } else {
                        ModuloCalculo.borrarFichero(ficheroErrores);
                        ModuloCalculo.copyFile(pathResultado, ficheroErrores);
                    }
                }
                catch (Exception e) {
                    ModuloCalculo.getLogger().error(e.getMessage(), e);
                    ModuloCalculo.borrarFichero(copiaEntrada);
                    ModuloCalculo.borrarFichero(pathResultado);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                ModuloCalculo.borrarFichero(copiaEntrada);
                ModuloCalculo.borrarFichero(pathResultado);
                throw throwable;
            }
            ModuloCalculo.borrarFichero(copiaEntrada);
            ModuloCalculo.borrarFichero(pathResultado);
        }
    }

    private static void borrarFichero(String pathFichero) {
        try {
            Files.delete(Paths.get(pathFichero, new String[0]));
        }
        catch (NoSuchFileException e) {
            ModuloCalculo.getLogger().trace(String.format(NO_SE_HA_BORRADO, pathFichero));
        }
        catch (IOException e) {
            ModuloCalculo.getLogger().error(String.format(NO_SE_HA_BORRADO, pathFichero), e);
        }
    }

    public static String procesarFicheroXML(String entradaXML) throws IOException {
        es.aeat.pret.c200.mc.ModuloCalculo.setModuloCalculo(true);
        Channel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        CalculoRetencionesXMLSrvImpl mod = null;
        File dest = null;
        String pathResultado = null;
        try {
            dest = File.createTempFile("stringfile-", null);
            destChannel = new FileOutputStream(dest).getChannel();
            byte[] bytesEntrada = entradaXML.getBytes();
            sourceChannel = Channels.newChannel(new ByteArrayInputStream(bytesEntrada));
            ((FileChannel)destChannel).transferFrom((ReadableByteChannel)sourceChannel, 0L, bytesEntrada.length);
            try {
                mod = new CalculoRetencionesXMLSrvImpl();
                pathResultado = mod.procesar(dest, null);
                String string = ModuloCalculo.fileToString(pathResultado);
                return string;
            }
            catch (Exception e) {
                ModuloCalculo.getLogger().error(e.getMessage(), e);
            }
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
            if (dest != null && !dest.delete()) {
                ModuloCalculo.getLogger().error("No se pudo borrar el fichero " + dest.getAbsolutePath());
            }
            if (pathResultado != null && !new File(pathResultado).delete()) {
                ModuloCalculo.getLogger().error(NO_SE_HA_BORRADO);
            }
        }
        return null;
    }

    private static void generarErrorEntradaNoExiste(File errores) throws FileNotFoundException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (PrintWriter writer = new PrintWriter(errores);){
            writer.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");
            writer.println("<AEATRetencionesError2021>");
            writer.println("<ErrorGeneral>");
            writer.println("<Linea>0</Linea>");
            writer.println("<Posicion>0</Posicion>");
            writer.println("<Descripcion>El fichero de entrada no existe.</Descripcion>");
            writer.println("</ErrorGeneral>");
            writer.println("</AEATRetencionesError2021>");
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String fileToString(String origen) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        Channel destChannel = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            File source = new File(origen);
            sourceChannel = new FileInputStream(source).getChannel();
            destChannel = Channels.newChannel(baos);
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            while (((FileChannel)sourceChannel).read(buffer) != -1) {
                buffer.flip();
                destChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                destChannel.write(buffer);
            }
            String string = baos.toString();
            return string;
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
        }
    }

    private static String copyFile(String origen, String destino) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            File dest;
            File source = new File(origen);
            sourceChannel = new FileInputStream(source).getChannel();
            if (destino == null) {
                dest = File.createTempFile("copyOf-" + source.getName() + "-", null);
                dest.deleteOnExit();
            } else {
                dest = new File(destino);
            }
            destChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)destChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
            String string = dest.getPath();
            return string;
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
        }
    }

    public static void main(String[] args) {
        es.aeat.pret.c200.mc.ModuloCalculo.setModuloCalculo(true);
        ModuloCalculo.configLog();
        AnalizarLineaComandos alc = new AnalizarLineaComandos();
        alc.setParametro("E", true, null, true);
        alc.setParametro("R", true, null, true);
        alc.setParametro("S", true, null, true);
        alc.setParametro("I", false, "null", false);
        String fichero = null;
        try {
            alc.parse(args);
            fichero = alc.getParametro("E");
            String errores = alc.getParametro("R");
            String flag = "";
            String salida = alc.getParametro("S");
            String adicional = alc.getParametro("I");
            if (!"null".equals(adicional)) {
                ResourceBundle bundle = ResourceBundle.getBundle("es/aeat/pret/c200/mc/c210/retenciones");
                System.out.println(String.valueOf(bundle.getString("acercade.titulo")) + " " + bundle.getString("acercade.periodo") + " " + bundle.getString("version.mc"));
            }
            ModuloCalculo.procesarFicheroXml(fichero, errores, flag, salida);
        }
        catch (AnalizarLineaComandoException ex) {
            ModuloCalculo.getLogger().error("Error en l\u00ednea de comandos", ex);
            System.exit(1);
        }
    }

    private static void configLog() {
        try {
            LogManager logManager = LogManager.getLogManager();
            InputStream prop = ModuloCalculo.class.getResourceAsStream("/es/aeat/pret/c200/mc/comun/logging.properties");
            logManager.readConfiguration(prop);
            prop.close();
            File file = new File(PathTrabajo.getPathTrabajoSinProtocolo(), "slf4j-jdk14-1.6.1.jar");
            if (file.exists()) {
                ModuloCalculo.addURL(file.toURI().toURL());
            }
        }
        catch (Exception e) {
            ModuloCalculo.getLogger().error("Error, could not add URL to system classloader", e);
        }
    }

    private static void addURL(URL u) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysloader, u);
    }

    public static Logger getLogger() {
        return LoggerFactory.getLogger(ModuloCalculo.class);
    }
}

