package es.aeat.pret.c200.imp.bean;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import es.aeat.pret.c200.api.bean.AscendienteBean;
import es.aeat.pret.c200.api.bean.DescendienteBean;
import es.aeat.pret.c200.api.bean.ErrorValidacionBean;
import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.api.bean.PerceptorBeanTipos;
import es.aeat.pret.c200.api.staxi.IEscribirError;
import es.aeat.pret.c200.api.staxi.IEscribirSalida;
import es.aeat.pret.c200.api.staxi.ILeeRetenedor;
import es.aeat.pret.c200.api.staxi.ILeeRetenido;


/**
 * Implementacin del bean de perceptor para el clculo de retenciones.
 * 
 * @author f00999ec
 *
 */
public class PerceptorBeanImpl implements PerceptorBean{
	
	private static final long serialVersionUID = 1L;
	
	// datos del retenedor
	protected String nifret = "00000004G";
	protected String aperet = PerceptorBeanTipos.NOMBREDEFECTO;
	/**
	 * NIF del perceptor
	 */
	protected String nifper = "";
	protected String apeper = PerceptorBeanTipos.NOMBREDEFECTO;
	/**
	 * Ao de nacimiento del perceptor
	 */
	protected int anoper;
	/**
	 * Situacin laboral
	 */
	protected int situper = PerceptorBeanTipos.ACTIVO;
	/**
	 * Situacin familiar
	 */
	protected int situfam = PerceptorBeanTipos.SITUACION3;
	/**
	 * NIF del cnyuge
	 */
	protected String nifcon = "";
	/**
	 * Tipo de contrato (Slo para situacion laboral = Activo)
	 */
	protected int contrato = PerceptorBeanTipos.GENERAL;
	/**
	 * Grado de discapacidad
	 */
	protected int discaper;
	/**
	 * Necesita ayuda falta de movilidad (Slo para DISCAPER mayo 33 menor 65)
	 */
	protected boolean movilper;
	/**
	 * Residencia habitual en Ceuta o Melilla
	 */
	protected boolean resiceme;
	/**
	 * Reduccin por movilidad geogrfica
	 */
	protected boolean movil;
	/**
	 * Movilidad geogrfico
	 * 
	 * protected BigDecimal MOVILGEO=BigDecimal.ZERO;
	 */
	/**
	 * retribuciones totales, dinerarias y en especie, importe ntegro
	 */
	protected BigDecimal retrib = BigDecimal.ZERO;
	/**
	 * reduccin por irregularidad artculo 17.2 etc.
	 */
	protected BigDecimal irregular1 = BigDecimal.ZERO;
	/**
	 * reduccin por irregularidad artculo 17.2 etc.
	 */
	protected BigDecimal irregular2 = BigDecimal.ZERO;
	/**
	 * GASTOS DEDUCIBLES (ART. 19.2, a), b) y c): COTIZACIONES A LA S. SOCIAL, MUTUTALIDADES...)
	 */
	protected BigDecimal cotizaciones = BigDecimal.ZERO;
	/**
	 * OTROS GASTOS: CUANTIA FIJA CON CARCTER GENERAL
	 */
	protected BigDecimal gastosgen = BigDecimal.ZERO;
	/**
	 * OTROS GASTOS: INCREMENTO POR MOVILIDAD GEOGRFICA
	 */
	protected BigDecimal incregasmovil = BigDecimal.ZERO;
	/**
	 * OTROS GASTOS. INCREMENTO PARA TRABAJADORES ACTIVOS CON DISCAPACIDAD
	 */
	protected BigDecimal incregasdistra = BigDecimal.ZERO;
	/**
	 * GASTOS ART 19.2.f): OTROS GASTOS (GASTOSGEN + INCREGASMOVIL + INGREGASDISTRA)
	 */
	protected BigDecimal otrosgastos = BigDecimal.ZERO;
	/**
	 * GASTOS DEDUCCIBLES
	 */
	protected BigDecimal gastos = BigDecimal.ZERO;
	protected BigDecimal minopago = BigDecimal.ZERO;
	protected BigDecimal minopagoa = BigDecimal.ZERO;
	/**
	 * los datos anteriores corresponden a rdtos. por trabajos realizados en Ceuta o Melilla
	 */
	protected boolean renceme;
	/**
	 * Prstamo vivienda
	 */
	protected boolean presviv;
	/**
	 * Minorado 
	 */
	protected boolean minorado;
	/**
	 * pensiones compensatorias satisfechas al cnyuge
	 */
	protected BigDecimal conyuge = BigDecimal.ZERO;
	/**
	 * importe de las anualidades satisfechas a los hijos
	 */
	protected BigDecimal anualidades = BigDecimal.ZERO;
	/**
	 * Descendientes
	 */
	protected List<DescendienteBean> descendientes = new ArrayList<>();
	private List<DescendienteBean> descendientesOrdenados = new ArrayList<>();
	/**
	 * Ascendientes
	 */
	protected List<AscendienteBean> ascendientes = new ArrayList<>();
	/**
	 * Regularizacin
	 */
	protected boolean regularizacion;
	/**
	 * causas de regularizacin
	 */
	protected boolean[] causa = new boolean[PerceptorBeanTipos.MAX_CAUSAS + 1];
	/**
	 * Retribuciones ya satisfechas con anterioridad a la regularizacin
	 */
	protected BigDecimal percibido = BigDecimal.ZERO;
	/**
	 * Retenciones e ingresos a cuenta ya practicados
	 */
	protected BigDecimal retenido = BigDecimal.ZERO;
	/**
	 * RETRIBUCIONES ANUALES CONSIDERADAS CON ANTERIORIDAD A LA REGULARIZACIN
	 */
	protected BigDecimal retriba = BigDecimal.ZERO;
	/**
	 * RETENCIONES TOTALES ANUALES CONSIDERADAS ANTES DE LA REGULARIZACIN
	 */
	protected BigDecimal importea = BigDecimal.ZERO;
	/**
	 * los trabajos anteriores a la regularizacin realizados en Ceuta o Melilla
	 */
	protected boolean rencemea;
	/**
	 * Base de retencion determinada antes de la regularizacin
	 */
	protected BigDecimal basea = BigDecimal.ZERO;
	/**
	 * RENDIMIENTO NETO A EFECTOS DEL CLCULO DE LA REDUCCIN POR OBTENCIN DE RENDIMIENTOS DEL TRABAJO
	 */
	protected BigDecimal rnt = BigDecimal.ZERO;
	/**
	 * Rendimiento neto reducido
	 */
	protected BigDecimal rntredu = BigDecimal.ZERO;
	/**
	 * mnimo personal
	 */
	protected BigDecimal minper = BigDecimal.ZERO;
	/**
	 * mnimo del contribuyente
	 */
	protected BigDecimal mincon = BigDecimal.ZERO;
	/**
	 * MINIMO POR DESCENDIENTES
	 */
	protected BigDecimal mindes = BigDecimal.ZERO;
	/**
	 * MINIMO POR DESCENDIENTES GENERAL
	 */
	protected BigDecimal mindesg = BigDecimal.ZERO;
	/**
	 * MINIMO POR DESCENDIENTES MENORES 3 AOS
	 */
	protected BigDecimal mindes3 = BigDecimal.ZERO;
	/**
	 * Reduccin por rendimientos del trabajo
	 */
	protected BigDecimal red20 = BigDecimal.ZERO;
	/**
	 * Reducciones por edad
	 */
	protected BigDecimal red65 = BigDecimal.ZERO;
	/**
	 * Reduccin por asistencia
	 */
	protected BigDecimal red75 = BigDecimal.ZERO;
	/**
	 * Reduccin por DISCAPACIDAD
	 */
	protected BigDecimal redis = BigDecimal.ZERO;
	/**
	 * Reduccin por edad del contribuyente
	 */
	protected BigDecimal per65 = BigDecimal.ZERO;
	/**
	 * Reduccin por edad de los ascendientes
	 */
	protected BigDecimal as65 = BigDecimal.ZERO;
	/**
	 * Reduccin por asistencia del contribuyente
	 */
	protected BigDecimal per75 = BigDecimal.ZERO;
	/**
	 * Reduccin por asistencia de los ascendientes
	 */
	protected BigDecimal as75 = BigDecimal.ZERO;
	/**
	 * MINIMO por ascendientes
	 */
	protected BigDecimal minas = BigDecimal.ZERO;
	/**
	 * Reduccin por discapacidad del contribuyente
	 */
	protected BigDecimal disper = BigDecimal.ZERO;
	/**
	 * MINIMO POR CONTRIBUYENTE DISCAPACITADO
	 */
	protected BigDecimal mindisc = BigDecimal.ZERO;
	/**
	 * Reduccin por discapacidad de los ascendientes
	 */
	protected BigDecimal disas = BigDecimal.ZERO;
	/**
	 * Reduccin por discapacidad de los descendientes
	 */
	protected BigDecimal disdes = BigDecimal.ZERO;
	/**
	 * Reduccin por asistencia del contribuyebte discapacitado
	 */
	protected BigDecimal asisper = BigDecimal.ZERO;
	/**
	 * Reduccin por asistencia de los ascendientes discapacitados
	 */
	protected BigDecimal asisas = BigDecimal.ZERO;
	/**
	 * Reduccin por asistencia de los descendienes discapacitados
	 */
	protected BigDecimal asisdes = BigDecimal.ZERO;
	/**
	 * Minimo por discapacidad de descendientes y ascendientes
	 */
	protected BigDecimal mdisdeas = BigDecimal.ZERO;
	/**
	 * Mnimo por discapacidad
	 */
	protected BigDecimal mindis = BigDecimal.ZERO;
	/**
	 * Mnimo personal y familiar
	 */
	protected BigDecimal minperfa = BigDecimal.ZERO;
	/**
	 * Suma de reducciones
	 */
	protected BigDecimal redu = BigDecimal.ZERO;
	/**
	 * Reduccin por ser pensionista
	 */
	protected BigDecimal pension = BigDecimal.ZERO;
	/**
	 * Reduccin por tener 2 o ms hijos con derecho
	 */
	protected BigDecimal hijos = BigDecimal.ZERO;
	/**
	 * Reduccin por desempleado
	 */
	protected BigDecimal desem = BigDecimal.ZERO;
	/**
	 * BASE DE RETENCIN
	 */
	protected BigDecimal base = BigDecimal.ZERO;
	/**
	 * cuota de retencin 1
	 */
	protected BigDecimal cuota1 = BigDecimal.ZERO;
	/**
	 * cuota de retencin 2
	 */
	protected BigDecimal cuota2 = BigDecimal.ZERO;
	/**
	 * cuota de retencin
	 */
	protected BigDecimal cuota = BigDecimal.ZERO;
	/**
	 * TIPO DE RETENCION
	 */
	protected BigDecimal tipo = BigDecimal.ZERO;
	/**
	 * TIPO DE RETENCION APLICABLE (A PARTIR DE LA REGULARIZACIN)
	 */
	protected BigDecimal tiporeg = BigDecimal.ZERO;
	/**
	 * TIPO DE RETENCION APLICABLE CON ANTERIORIDAD A LA REGULARIZACION
	 */
	protected BigDecimal tipoa = BigDecimal.ZERO;
	/**
	 * IMPORTE DE LA RETENCIN PARA LA DETERMINACIN DEL TIPO DE RETENCIN A PARTIR DE LA REGULARIZACIN
	 */
	protected BigDecimal importereg= BigDecimal.ZERO;
	/**
	 * DIFERENCIA POSITIVA ENTRE LA CUOTA O CUOTACM Y EL MINOPAGO
	 */
	protected BigDecimal diferenciapositiva = BigDecimal.ZERO;
	/**
	 * Importe anual de las retenciones
	 */
	protected BigDecimal importe = BigDecimal.ZERO;
	/**
	 * Nmero de descendientes menores de 3 aos o adoptados hace menos de tres aos
	 */
	protected int numdes3;
	@SuppressWarnings("unused")
	private int numdesmas3;
	@SuppressWarnings("unused")
	private int numdesmas3en;
	/**
	 * Nmero de descendientes menores de 3 aos
	 */
	@SuppressWarnings("unused")
	private int numdes3en;
	/**
	 * Nmero de descendientes entre 3 y 25 aos
	 */
	protected int numdes325;
	/**
	 * Nmero de descendientes entre 3 y 25 aos computados por entero
	 */
	@SuppressWarnings("unused")
	private int numdes325en;
	/**
	 * Cmputo del hijo 1
	 */
	@SuppressWarnings("unused")
	private String comhijo1 = "";
	/**
	 * Cmputo del hijo 2
	 */
	@SuppressWarnings("unused")
	private String comhijo2 = "";
	/**
	 * Cmputo del hijo 3
	 */
	@SuppressWarnings("unused")
	private String comhijo3 = "";
	/**
	 * Nmero de descendientes discapacitados 33 - 65
	 */
	protected int numdes3365;
	/**
	 * Nmero de descendientes discapacitados 33 - 65 % computados por entero
	 */
	@SuppressWarnings("unused")
	private int numdes3365en;
	/**
	 * Nmero de descendientes CON movilidad reducida
	 */
	protected int numdesmov;
	/**
	 * Nmero de descendientes CON movilidad reducida computados por entero
	 */
	protected int numdesmoven;
	/**
	 * Nmero de descendientes discapacitados al 65 %
	 */
	protected int numdes65;
	/**
	 * Nmero de descendientes discapacitados al 65 % computados por entero
	 */
	protected int numdes65en;
	/**
	 * Nmero total de descendientes
	 */
	protected int numdes;
	/**
	 * Nmero total de ascendientes
	 */
	protected int numas;
	/**
	 * Nmero de ascendientes discapacitados 33 - 65 aos
	 */
	protected int numas3365;
	/**
	 * Nmero de ascendientes discapacitados 33 - 65 aos Computados por entero
	 */
	protected int numas3365en;
	/**
	 * Nmero de ascendientes CON movilidad reducida
	 */
	protected int numasmov;
	/**
	 * Nmero de ascendientes CON movilidad reducida Computados por entero
	 */
	protected int numasmoven;
	/**
	 * Nmero de ascendientes discapacitados 65
	 */
	protected int numas65;
	/**
	 * Nmero de ascendientes discapacitados 65 Computados por entero
	 */
	protected int numas65en;
	/**
	 * Nmero de ascendientes 65 AOS
	 */
	protected int numas65a;
	/**
	 * Nmero de ascendientes 65 AOS Computados por entero
	 */
	protected int numas65aen;
	/**
	 * Nmero de ascendientes mayores 75 aos
	 */
	protected int numas75a;
	/**
	 * Nmero de ascendientes mayores 75 aos Computados por entero
	 */
	protected int numas75aen;
	/**
	 * Minimo personal y familiar anterior a la regularizacin
	 */
	protected BigDecimal minperfaa = BigDecimal.ZERO;
	// para saber si tengo que hacer los clculos de rendimientos sujetos a retencion...
	protected boolean exentos;
	protected boolean ceumeli;
	/**
	 * CUOTA DE CEUTA O MELILLA
	 */
	protected BigDecimal cuotacm = BigDecimal.ZERO;

	// VARIABLES DEL DEL SERVICIO DE VALIDARLEERFICHEROSRV ValidarLeerFicheroSrvImpl
	protected File ficheroSalida=null;
	protected File ficheroError=null;
	protected String nombreFicheroEntrada;
	protected int[] cuantosRetenidos;
	protected int nuneroRetenedorese;
	protected int numRetenidos;
	protected boolean errorImportacion=false;
	protected boolean tenemosError=false;
	protected boolean comprobandoSalida=false;
	/**
	 * para saber cuantos errores al importar un fichero hemos tenido, solo se usa realmente para importar un xml al programa y saber si 
	 * al comprobar si es un fichero de salida tenemos mas de uno, que seria que no es de salida, con lo que tendriamos 
	 * errores de esquema
	*/ 
	protected int erroresImportacion=0;	
	protected ILeeRetenedor staxReto = null;
	protected ILeeRetenido staxReti = null; 
	protected IEscribirSalida stax = null;
	protected IEscribirError staxE = null;
	
	// VARIABLES DEL SERVICIO DE CALCULOXML CalculoRetencionesXMLSrvImpl
	protected boolean cerradaSalidaPorError=false;
	protected boolean huboErroresAntes=false;
	protected boolean errorValidacion=false;
	protected boolean abiertoRetenedor=false;
	protected int indiceRetenedor=0;
	protected int indiceRetenido=0;
	protected File ficheroSalidaCalculo=null;
	protected int numeroRetenedoresCalculo=0;
	protected int numeroRetenidosCalculo=0;
	protected List<ErrorValidacionBean> err = new ArrayList<>();
	
	protected String desarrollo="";
	
	public PerceptorBeanImpl() {
		// no hace nada
	}

	private Logger getLog() {
		return Logger.getLogger(PerceptorBeanImpl.class.getName());
	}

	@Override
	public Object getValor(String partida) {
		try {
			Class<? extends PerceptorBeanImpl> c = getClass();
			Field f = c.getDeclaredField(partida);
			Class<?> fieldType = f.getType();
			Object object = f.get(this);
			Object retValue;
			if (fieldType.isArray()) {
				retValue = object;
			} else if (fieldType.isAssignableFrom(BigDecimal.class)) {
				retValue = new BigDecimal(object.toString());
			} else if (fieldType.isAssignableFrom(Integer.TYPE)) {
				String intVal = object.toString();
				retValue = Integer.valueOf(intVal);
			} else if (fieldType.isAssignableFrom(Boolean.TYPE)
					|| fieldType.isAssignableFrom(boolean.class)) {
				retValue = Boolean.valueOf(object.toString());
			} else if (fieldType.isAssignableFrom(ArrayList.class)) {
				retValue = ((ArrayList<?>) object).clone();
			} else {
				retValue = object;
			}
			return retValue;
		} catch (Exception ex) {
			getLog().severe(ex.getMessage());
		}
		return null;
	}

	@Override
	public void setValor(String partida, Object valor) {
		try {
			Class<? extends PerceptorBeanImpl> c = getClass();
			Field f = c.getDeclaredField(partida);
			Class<?> fieldType = f.getType();
			Object objectValue;
			if (fieldType.isAssignableFrom(BigDecimal.class)) {
				if (valor instanceof BigDecimal) {
					objectValue = valor;
				} else {
					String num = (String) valor;
					if ("".equals(num)) {
						objectValue = BigDecimal.ZERO;
					} else {
						valor = num.replace(',', '.');
						BigDecimal aux = new BigDecimal((String) valor).setScale(2);
						if (aux.doubleValue() == 0){
							objectValue = BigDecimal.ZERO;
						} else{
							objectValue = aux;
						}
						aux=null;
					}		
				}
			} else if (fieldType.isAssignableFrom(Integer.TYPE)) {
				if (valor instanceof Integer) {
					objectValue = valor;
				} else {
					if ("".equals((String) valor)) {
						valor = "0";
					}
					objectValue = Integer.valueOf((String) valor);
				}
			} else if (fieldType.isAssignableFrom(Boolean.TYPE)) {
				if (valor instanceof Boolean) {
					objectValue = valor;
				} else {
					objectValue = !"0".equals(valor.toString()) ? true : false;
				}
			} else if (fieldType.isAssignableFrom(List.class)) {
				f.set(this, valor);
				return;
			} else {
				objectValue = valor;
			}
			f.set(this, objectValue);
		} catch (Exception e) {
			getLog().severe(e.getMessage());
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getValor(String partida, int indice) {
		Object objectValue = null;
		try {
			Class<? extends PerceptorBeanImpl> c = getClass();
			Field f = c.getDeclaredField(partida);
			Class<?> fieldType = f.getType();
			if (fieldType.isArray()) {
				objectValue = Array.get(f.get(this), indice);
			} else if (fieldType.isAssignableFrom(List.class)) {
				List<Object> v = (List<Object>) f.get(this);

				if (indice < 0 || indice >= v.size()) {
					return null;
				}
				objectValue = v.get(indice);
			}
		} catch (Exception e) {
			getLog().severe(e.getMessage());
			objectValue = null;
		}
		return objectValue;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void setValor(String partida, Object valor, int indice) {
		try {
			Class<? extends PerceptorBeanImpl> c = getClass();
			Field f = c.getDeclaredField(partida);
			Class<?> fieldType = f.getType();
			if (fieldType.isArray()) {
				Boolean boolVal = Boolean.valueOf(valor.toString());
				Array.set(f.get(this), indice, boolVal);
			} else if (fieldType.isAssignableFrom(List.class)) {
				List<Object> v = (List<Object>) f.get(this);
				if (indice < 0) {
					return;
				}
				// aadimos uno nuevo al final
				if (indice >= v.size() && valor != null) {
					v.add(valor);
					return;
				}
				if (valor != null) {
					v.set(indice, valor);
				} else {
					v.remove(indice);
				}
			}
		} catch (Exception e) {
			getLog().severe(e.getMessage());
		}
	}
	
	@Override
	public AscendienteBean createAscendienteBean(Integer anioNacimiento,
			Integer convivencia, Integer discapacidad, boolean movilidadReducida) {
		return new AscendienteBeanImpl(anioNacimiento, convivencia, discapacidad, movilidadReducida);
	}

	@Override
	public DescendienteBean createDescendienteBean(Integer anioNacimiento,
			Integer anioAdopcion, boolean porEntero, Integer discapacidad, boolean movilidadReducida) {
		
		return new DescendienteBeanImpl(anioNacimiento, anioAdopcion, porEntero, discapacidad, movilidadReducida);
	}

	@Override
	public AscendienteBean createAscendienteBean() {
		return new AscendienteBeanImpl(0, 0, 0, false);
	}

	@Override
	public DescendienteBean createDescendienteBean() {
		return new DescendienteBeanImpl(0, 0, false, 0, false);
	}

	@Override
	public List<DescendienteBean> getDescendientes() {
		if(descendientes==null){
			descendientes = new ArrayList<>();
		}
		return descendientes;
	}

	@Override
	public List<AscendienteBean> getAscendientes() {
		if(ascendientes==null){
			ascendientes = new ArrayList<>();
		}
		return ascendientes;
	}

	public List<DescendienteBean> getDescendientesOrdenados() {
		if(descendientesOrdenados==null){
			descendientesOrdenados = new ArrayList<>();
		}
		return descendientesOrdenados;
	}

	@Override
	public BigDecimal getValorAsBigDecimal(String partida) {
		Object valor = getValor(partida);
		
		if (valor instanceof BigDecimal) {
			return (BigDecimal) valor;
		}
		throw new IllegalArgumentException("La partida " + partida + " no es un BigDecimal");
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public void borraDatos() {
		descendientes = null;
		descendientesOrdenados = null;
//		descendientesOrdenados = getDescendientesOrdenados()
		ascendientes = null;
		ascendientes = getAscendientes();
		causa = new boolean[PerceptorBeanTipos.MAX_CAUSAS + 1];
		
		// INIT MODELO
		try {
			Class c = getClass();
			Field[] fields = c.getDeclaredFields();

			for (int i = 0; i < fields.length; i++) {
				int modifiers = fields[i].getModifiers();
				if (Modifier.isFinal(modifiers)) {
					continue;
				}
				Class fieldType = fields[i].getType();
				if (fieldType.isAssignableFrom(BigDecimal.class)) {
					fields[i].set(this, BigDecimal.ZERO);
				} else if (fieldType.isAssignableFrom(Integer.TYPE)) {
					fields[i].set(this, 0);
				} else if (fieldType.isAssignableFrom(Boolean.TYPE)) {
					fields[i].set(this, false);
				} else if (fieldType.isAssignableFrom(String.class)) {
					fields[i].set(this, "");
				} else if (fieldType.isAssignableFrom(List.class)) {
					if (!"vistas".equals(fields[i].getName())) {
						fields[i].set(this, new ArrayList<String[]>());
					}
				} else if (fieldType.isArray()) {
					if("cuantosRetenidos".equalsIgnoreCase(fields[i].getName())){
						fields[i].set(this, Array.newInstance(int.class, 0));
					} else{
						fields[i].set(this, Array.newInstance(boolean.class, PerceptorBeanTipos.MAX_CAUSAS + 1));
					}
				}
			}
			
			// COMO ME DA PROBLEMAS AL IMPORTAR, SE QUEDAN VACIOS, LOS METO A MANO
			nifret = "00000004G";
			aperet = PerceptorBeanTipos.NOMBREDEFECTO;
			nifper = "";
			apeper = PerceptorBeanTipos.NOMBREDEFECTO;
			
			fields=null;
		} catch (Exception e) {
			getLog().severe(e.getMessage());
		}
	}
	
	// COSAS DEL DEL SERVICIO DE VALIDARLEERFICHEROSRV ValidarLeerFicheroSrvImpl
	@Override
	public File getFicheroSalida() {
		return ficheroSalida;
	}
	
	@Override
	public void setFicheroSalida(File ficheroSalida) {
		this.ficheroSalida = ficheroSalida;
	}
	
	@Override
	public File getFicheroError() {
		return ficheroError;
	}
	
	@Override
	public void setFicheroError(File ficheroError) {
		this.ficheroError = ficheroError;
	}
	
	@Override
	public String getNombreFicheroEntrada() {
		return nombreFicheroEntrada;
	}
	
	@Override
	public void setNombreFicheroEntrada(String nombreFicheroEntrada) {
		this.nombreFicheroEntrada = nombreFicheroEntrada;
	}
	
	@Override
	public int[] getCuantosRetenidos() {
		return cuantosRetenidos;
	}
	
	@Override
	public void setCuantosRetenidos(int[] cuantosRetenidos) {
		this.cuantosRetenidos = cuantosRetenidos;
	}
	
	@Override
	public int getNuneroRetenedorese() {
		return nuneroRetenedorese;
	}
	
	@Override
	public void setNuneroRetenedorese(int nuneroRetenedorese) {
		this.nuneroRetenedorese = nuneroRetenedorese;
	}
	
	@Override
	public int getNumRetenidos() {
		return numRetenidos;
	}
	
	@Override
	public void setNumRetenidos(int numRetenidos) {
		this.numRetenidos = numRetenidos;
	}
	
	@Override
	public boolean isErrorImportacion() {
		return errorImportacion;
	}
	
	@Override
	public void setErrorImportacion(boolean errorImportacion) {
		this.errorImportacion = errorImportacion;
	}
	
	@Override
	public boolean isTenemosError() {
		return tenemosError;
	}
	
	@Override
	public void setTenemosError(boolean tenemosError) {
		this.tenemosError = tenemosError;
	}
	
	@Override
	public boolean isComprobandoSalida() {
		return comprobandoSalida;
	}
	
	@Override
	public void setComprobandoSalida(boolean comprobandoSalida) {
		this.comprobandoSalida = comprobandoSalida;
	}
	
	@Override
	public int getErroresImportacion() {
		return erroresImportacion;
	}
	
	@Override
	public void setErroresImportacion(int erroresImportacion) {
		this.erroresImportacion = erroresImportacion;
	}
	
	@Override
	public ILeeRetenedor getStaxReto() {
		return staxReto;
	}
	
	@Override
	public void setStaxReto(ILeeRetenedor staxReto) {
		this.staxReto = staxReto;
	}
	
	@Override
	public ILeeRetenido getStaxReti(){
		return staxReti;
	}
	
	@Override
	public void setStaxReti(ILeeRetenido staxReti) {
		this.staxReti = staxReti;
	}
	
	@Override
	public IEscribirSalida getStax() {
		return stax;
	}
	
	@Override
	public void setStax(IEscribirSalida stax) {
		this.stax = stax;
	}
	
	@Override
	public IEscribirError getStaxE(){
		return staxE;
	}
	
	@Override
	public void setStaxE(IEscribirError staxE) {
		this.staxE = staxE;
	}
	
	// COSAS DEL SERVICIO DE CALCULOXML CalculoRetencionesXMLSrvImpl
	@Override
	public boolean isCerradaSalidaPorError() {
		return cerradaSalidaPorError;
	}
	
	@Override
	public void setCerradaSalidaPorError(boolean cerradaSalidaPorError) {
		this.cerradaSalidaPorError = cerradaSalidaPorError;
	}
	
	@Override
	public boolean isHuboErroresAntes() {
		return huboErroresAntes;
	}
	
	@Override
	public void setHuboErroresAntes(boolean huboErroresAntes) {
		this.huboErroresAntes = huboErroresAntes;
	}
	
	@Override
	public boolean isErrorValidacion() {
		return errorValidacion;
	}
	
	@Override
	public void setErrorValidacion(boolean errorValidacion) {
		this.errorValidacion = errorValidacion;
	}
	
	@Override
	public boolean isAbiertoRetenedor() {
		return abiertoRetenedor;
	}
	
	@Override
	public void setAbiertoRetenedor(boolean abiertoRetenedor) {
		this.abiertoRetenedor = abiertoRetenedor;
	}
	
	@Override
	public int getIndiceRetenedor() {
		return indiceRetenedor;
	}
	
	@Override
	public void setIndiceRetenedor(int indiceRetenedor) {
		this.indiceRetenedor = indiceRetenedor;
	}
	
	@Override
	public int getIndiceRetenido() {
		return indiceRetenido;
	}
	
	@Override
	public void setIndiceRetenido(int indiceRetenido) {
		this.indiceRetenido = indiceRetenido;
	}
	
	@Override
	public File getFicheroSalidaCalculo() {
		return ficheroSalidaCalculo;
	}
	
	@Override
	public void setFicheroSalidaCalculo(File ficheroSalidaCalculo) {
		this.ficheroSalidaCalculo = ficheroSalidaCalculo;
	}
	
	@Override
	public int getNumeroRetenedoresCalculo() {
		return numeroRetenedoresCalculo;
	}
	
	@Override
	public void setNumeroRetenedoresCalculo(int numeroRetenedoresCalculo) {
		this.numeroRetenedoresCalculo = numeroRetenedoresCalculo;
	}
	
	@Override
	public int getNumeroRetenidosCalculo() {
		return numeroRetenidosCalculo;
	}
	
	@Override
	public void setNumeroRetenidosCalculo(int numeroRetenidosCalculo) {
		this.numeroRetenidosCalculo = numeroRetenidosCalculo;
	}
	
	@Override
	public void setErr(ErrorValidacionBean error){
		err.add(error);
	}
	
	@Override
	public List<ErrorValidacionBean> getErr(){
		return err;
	}
	
	@Override
	public void borrarErr(){
		err = new ArrayList<>();
	}

	@Override
	public void escribirDesarrollo(String texto){
		desarrollo = desarrollo.concat(texto+"\n");
	}
	
	@Override
	public String obtenerDesarrollo(){
		return desarrollo;
	}
	
	@Override
	public void borrarDesarrollo(){
		desarrollo="";
	}
	
}
