package es.aeat.pret.c200.c240.util;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;

import es.aeat.pret.c200.api.bean.AscendienteBean;
import es.aeat.pret.c200.api.bean.DescendienteBean;
import es.aeat.pret.c200.api.bean.PerceptorBean;
import es.aeat.pret.c200.api.bean.PerceptorBeanTipos;
import es.aeat.pret.c200.api.staxi.ILeeRetenido;
import es.aeat.pret.c200.imp.bean.PerceptorBeanImpl;
import es.aeat.pret.c200.util.NombreNif;


public class LeeRetenido implements ILeeRetenido{
	
	private static final long serialVersionUID = 1L;
	private enum Element {NIF,APELLIDOSNOMBRE,ANIONACIMIENTO,COMUNIDADAUTONOMA,RESIDENCIACEUTAMELILLA,SITUACION1,SITUACION2,NIFCONYUGE,SITUACION3,
		GRADO1, GRADO2, MOVILIDADREDUCIDA, TRABAJADORACTIVO, DESEMPLEADO, PENSIONISTA, OTRASITUACION, CONTRATO, MOVILIDADGEOGRAFICA, 
		//CambioResidencia, 
		DESCENDIENTE, ASCENDIENTE, ANIOADOPCION, COMPUTADOENTERO, CONVIVENCIA, 
		
		RETENIDO, RETENEDOR, 
		
		RETRIBANUALES, IRREGULARIDAD1, IRREGULARIDAD2,COTIZACIONES,PENSIONCOMPENSATORIA,ANUALIDADESHIJOS,RDTOSOBTENIDOSCEUTAMELILLA,PAGOPRESTAMOSVIVIENDA,
		
		CAUSA, RETRIBSATISFECHAS, RETENCIONPRACTICADA, RETRIBANUALESINICIALES, RETENCIONANUALINICIAL, RESIDENCIAINICIALCEUTAMELILLA,
		MINIMOPERSONALFAMILIARINICIAL, BASERETENCION, TIPORETENCION, MINORACIONPRESTAMOSVIVIENDA,
		
		AEATRETENCIONESENTRADA2024, IDDOC, CODMODELO, EJERCICIO
		} 
	
	
	private XMLInputFactory factory=null; 
	private final HashMap<String, Element> nameToTypeMapping = new HashMap<>();
	private StringBuilder currentText; 
	private Element currentElement; 
	private PerceptorBean modelo=null;
	private ArrayList<NombreNif> lista = null;
	private NombreNif retenido;
	String nif;
	ArrayList<Integer> causas = null;
	/** 
	 * para saber a quien corresponde la discapacidad y el ao de nacimiento (Retenido 1, Descendiente 2, Ascendiente 3)
	 */
	int tipoRetiDescAsc=0;
	List<DescendienteBean> datosDescendientes = null;
	List<AscendienteBean> datosAscendientes = null;
	DescendienteBean descend = null;
	AscendienteBean ascend = null;
	
	int indiceRetenedorALeer;
	int indiceRetenedorLeido=-1;
	int indiceRetenidoALeer;
	int indiceRetenidoLeido=-1;
	boolean estamosRetenido=false;
	XMLStreamReader xmlReader=null;
	// para no importar las causas al traer el xml al programa, ni nif y nombre
	boolean importarXML=false;
	boolean buscarRetenido=false;
	
	boolean retenidoEncontrado=false;
	
	boolean soloLeer=false;
	
	public LeeRetenido(){
		nameToTypeMapping.put( "Nif" , Element.NIF); 
		nameToTypeMapping.put( "ApellidosNombre" , Element.APELLIDOSNOMBRE); 
		nameToTypeMapping.put( "Nacimiento" , Element.ANIONACIMIENTO); 
		nameToTypeMapping.put( "comunidadAutonoma" , Element.COMUNIDADAUTONOMA); 
		nameToTypeMapping.put( "ResidenciaCeutaMelilla" , Element.RESIDENCIACEUTAMELILLA); 
		nameToTypeMapping.put( "Situacion1" , Element.SITUACION1); 
		nameToTypeMapping.put( "Situacion2" , Element.SITUACION2);
		nameToTypeMapping.put( "NifConyuge" , Element.NIFCONYUGE);
		nameToTypeMapping.put( "Situacion3" , Element.SITUACION3);
		nameToTypeMapping.put( "Grado1" , Element.GRADO1); 
		nameToTypeMapping.put( "Grado2" , Element.GRADO2);
		nameToTypeMapping.put( "MovilidadReducida" , Element.MOVILIDADREDUCIDA);
		nameToTypeMapping.put( "TrabajadorActivo" , Element.TRABAJADORACTIVO);
		nameToTypeMapping.put( "Desempleado" , Element.DESEMPLEADO);
		nameToTypeMapping.put( "Pensionista" , Element.PENSIONISTA);
		nameToTypeMapping.put( "OtraSituacion" , Element.OTRASITUACION);
		nameToTypeMapping.put( "Contrato" , Element.CONTRATO);
		nameToTypeMapping.put( "MovilidadGeografica" , Element.MOVILIDADGEOGRAFICA);
//		nameToTypeMapping.put( "CambioResidencia" , Element.CambioResidencia)
		
		nameToTypeMapping.put( "Descendiente" , Element.DESCENDIENTE);
		nameToTypeMapping.put( "Ascendiente" , Element.ASCENDIENTE);
		nameToTypeMapping.put( "Adopcion" , Element.ANIOADOPCION);
		nameToTypeMapping.put( "ComputadoEntero" , Element.COMPUTADOENTERO);
		nameToTypeMapping.put( "Convivencia" , Element.CONVIVENCIA);
		nameToTypeMapping.put( "RetribAnuales" , Element.RETRIBANUALES);
		
		nameToTypeMapping.put( "Retenido" , Element.RETENIDO);
		nameToTypeMapping.put( "Retenedor" , Element.RETENEDOR);
		
		nameToTypeMapping.put( "Irregularidad1" , Element.IRREGULARIDAD1);
		nameToTypeMapping.put( "Irregularidad2" , Element.IRREGULARIDAD2); 
		nameToTypeMapping.put( "Cotizaciones" , Element.COTIZACIONES); 
		nameToTypeMapping.put( "PensionCompensatoria" , Element.PENSIONCOMPENSATORIA); 
		nameToTypeMapping.put( "AnualidadesHijos" , Element.ANUALIDADESHIJOS); 
		nameToTypeMapping.put( "RdtosObtenidosCeutaMelilla" , Element.RDTOSOBTENIDOSCEUTAMELILLA);
		nameToTypeMapping.put( "PagoPrestamosVivienda" , Element.PAGOPRESTAMOSVIVIENDA);
		
		nameToTypeMapping.put( "Causa" , Element.CAUSA);
		nameToTypeMapping.put( "RetribSatisfechas" , Element.RETRIBSATISFECHAS);
		nameToTypeMapping.put( "RetencionPracticada" , Element.RETENCIONPRACTICADA); 
		nameToTypeMapping.put( "RetribAnualesIniciales" , Element.RETRIBANUALESINICIALES); 
		nameToTypeMapping.put( "RetencionAnualInicial" , Element.RETENCIONANUALINICIAL); 
		nameToTypeMapping.put( "ResidenciaInicialCeutaMelilla" , Element.RESIDENCIAINICIALCEUTAMELILLA);
		nameToTypeMapping.put( "MinimoPersonalFamiliarInicial" , Element.MINIMOPERSONALFAMILIARINICIAL);
		nameToTypeMapping.put( "BaseRetencion" , Element.BASERETENCION); 
		nameToTypeMapping.put( "TipoRetencion" , Element.TIPORETENCION);
		nameToTypeMapping.put( "MinoracionPrestamosVivienda" , Element.MINORACIONPRESTAMOSVIVIENDA);
		
		nameToTypeMapping.put( "AEATRetencionesEntrada2024" , Element.AEATRETENCIONESENTRADA2024); 
		nameToTypeMapping.put( "IdDoc" , Element.IDDOC); 
		nameToTypeMapping.put( "CodModelo" , Element.CODMODELO); 
		nameToTypeMapping.put( "Ejercicio" , Element.EJERCICIO); 
	}
	
	@Override
	public void preparamosLectura() {
		indiceRetenedorLeido=-1;
		indiceRetenidoLeido=-1;
	}

	@Override
	public void crearXMLReader(FileInputStream input, PerceptorBean modelo,
			boolean importarXML, boolean buscarRetenido, boolean soloLeer)
			throws XMLStreamException {
		if(factory==null){
			factory = XMLInputFactory.newInstance();
			// Prevenir ataques XXE
			factory.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);
			factory.setProperty(XMLInputFactory.SUPPORT_DTD, false);
		}
		if(xmlReader==null){
			xmlReader = factory.createXMLStreamReader(input);
		}
		
		this.modelo=modelo;
		this.importarXML = importarXML;
		this.buscarRetenido = buscarRetenido;
		
		this.soloLeer=soloLeer;
	}

	@Override
	public void borrarLista() {
		if(lista!=null){
			lista=null;
		}
	}

	@Override
	public void cerrarReader() {
		try {
			if(lista!=null){
				lista=null;
			}
			
			if(xmlReader!=null){
				xmlReader.close();
				xmlReader=null;
			}
			
			modelo=null;
			factory=null;
			
		} catch (XMLStreamException e) {
			getLog().severe(e.getMessage());
		} 
	}

	@Override
	public void readXml(int indiceRetenedor, int indiceRetenido)
			throws XMLStreamException {
		this.indiceRetenedorALeer=indiceRetenedor;
		this.indiceRetenidoALeer=indiceRetenido;
		
		while (xmlReader.hasNext()) {
			int eventType = xmlReader.next(); 
			switch(eventType) { 
			case XMLEvent.CHARACTERS:
				processText(xmlReader.getText()); 
				break;
			case XMLEvent.END_ELEMENT: 
				if(ended(xmlReader.getLocalName())){
					return;
				}
				break; 
			case XMLEvent.START_ELEMENT: 
				startElement(xmlReader.getLocalName());
				break ;
			case XMLEvent.DTD:
			case XMLEvent.COMMENT:
			case XMLEvent.CDATA:
			case XMLEvent.SPACE:
			default:
				break;
			} 
		}
	}

	@Override
	public List<String> getLista() {
		if(lista==null){
			return null;
		}
		
		ArrayList<String> hm = new ArrayList<>();
		int numl = lista.size();
		for(int i=0;i<numl;i++){
			NombreNif nn = (NombreNif)lista.get(i);
			hm.add(nn.getNombre()+"-"+nn.getNif());
		}
		
		return hm;
	}

	@Override
	public boolean encontrado() {
		return retenidoEncontrado;
	}
	
	private void processText(String text) { 
		
		if(currentElement != null && currentText != null) { 
			currentText.append(text); 
		} 
	} 

	private void startElement(String localName) throws XMLStreamException { 
		currentElement = nameToTypeMapping.get(localName); 
		currentText = new StringBuilder(256); 
		
		// no quiero que haga nada con esto
		if(currentElement == Element.AEATRETENCIONESENTRADA2024|| currentElement == Element.IDDOC 
				|| currentElement == Element.CODMODELO || currentElement == Element.EJERCICIO ){
			return;
		}
		// leemos
		if(soloLeer){
			if(currentElement == Element.RETENEDOR) {
				
				estamosRetenido=false;
				indiceRetenedorLeido++;
				indiceRetenidoLeido=-1;
				if(indiceRetenedorALeer==indiceRetenedorLeido){
					lista=new ArrayList<>();
				}
				return;
			}
			if(currentElement == Element.RETENIDO) {
				if(buscarRetenido){
					indiceRetenidoLeido++;
				}
	
				estamosRetenido=true;
				retenido=new NombreNif();
				return;
			}
			
			// si viene cualquier otra cosa, return
			return;
		} else {
			// guardamos
			// cuando estamos calculando o metiendo importando xml a modelo
			if(currentElement == Element.RETENEDOR) {
				estamosRetenido=false;
				indiceRetenedorLeido++;
				indiceRetenidoLeido=-1;
	
				return;
			}
			
			if(currentElement == Element.RETENIDO) {
				estamosRetenido=true;
				retenido=new NombreNif();
				
				indiceRetenidoLeido++;
				
				String nifRete = (String)modelo.getValor(PerceptorBeanTipos.P_NIFRET);
				String nombreRete = (String)modelo.getValor(PerceptorBeanTipos.P_APERET);
				
				modelo.borraDatos();
				
				modelo.setValor(PerceptorBeanTipos.P_NIFRET, nifRete);
				modelo.setValor(PerceptorBeanTipos.P_APERET, nombreRete);
				
				return;
			}
			
			if(indiceRetenedorALeer!=indiceRetenedorLeido || indiceRetenidoALeer!=indiceRetenidoLeido){
				return;
			}
			
			if(currentElement == Element.NIF) {
				retenidoEncontrado=true;
				if(estamosRetenido){
					tipoRetiDescAsc=1;
				}
				return;
			}
			if(currentElement == Element.DESCENDIENTE){
				tipoRetiDescAsc=2;
				descend = modelo.createDescendienteBean();
				datosDescendientes = modelo.getDescendientes();
				return;
			}
			if(currentElement == Element.ASCENDIENTE){
				tipoRetiDescAsc=3;
				ascend = modelo.createAscendienteBean();
				datosAscendientes = modelo.getAscendientes();
				return;
			}
			
			if(currentElement == Element.ANIONACIMIENTO){			
				if(indiceRetenedorALeer==indiceRetenedorLeido && indiceRetenidoALeer==indiceRetenidoLeido){		
					if(tipoRetiDescAsc==2){
						descend.setAnioAdopcion(0);
						descend.setPorEntero(false);
						descend.setDiscapacidad(0);
						descend.setMovilidadReducida(false);
					} else if(tipoRetiDescAsc==3){		
						ascend.setConvivencia(0);
						ascend.setDiscapacidad(0);
						ascend.setMovilidadReducida(false);
					}
				}
				return;
			}
			
			if(currentElement == Element.GRADO1){
				if(indiceRetenedorALeer==indiceRetenedorLeido && indiceRetenidoALeer==indiceRetenidoLeido){
					if(tipoRetiDescAsc==1){
						modelo.setValor(PerceptorBeanTipos.P_MOVILPER, "0");
					}
					if(tipoRetiDescAsc==2){
						descend.setDiscapacidad(0);
					}
					if(tipoRetiDescAsc==3){
						ascend.setDiscapacidad(0);
					}
				}
				return;
			}
			
			if(currentElement == Element.TRABAJADORACTIVO){
				if(modelo!=null && indiceRetenedorALeer==indiceRetenedorLeido && indiceRetenidoALeer==indiceRetenidoLeido){
					modelo.setValor(PerceptorBeanTipos.P_MOVIL, "0");
					// 2016 QUITAMOS CAMBIORESI
	//				modelo.setValor("CAMBIORESI", "");//CAMBIO AQUI
				}
				return;
			}
			
			if(currentElement == Element.RETRIBANUALES){
				if(modelo!=null && indiceRetenedorALeer==indiceRetenedorLeido && indiceRetenidoALeer==indiceRetenidoLeido){
					// inicializamos algunos campos ver cuales faltan antes de estos
					modelo.setValor(PerceptorBeanTipos.P_RENCEME, "0");
					modelo.setValor(PerceptorBeanTipos.P_PRESVIV, "0");
				}
				return;
			}
			
			return;
		}
	
	}

	private boolean ended(String localName) {
		currentElement = nameToTypeMapping.get(localName);
		if(currentElement != null) { 
			
			// no quiero que haga nada con esto
			if(currentElement == Element.AEATRETENCIONESENTRADA2024|| currentElement == Element.IDDOC 
					|| currentElement == Element.CODMODELO || currentElement == Element.EJERCICIO ){
				return false;
			}
			
			// leemos
			if(soloLeer){
				
				// si no estoy en el retenedor que tengo que estar, salgo
				if(indiceRetenedorALeer!=indiceRetenedorLeido){
					return false; // para que siga leyendo
				}
				
				if( !"Nif".equalsIgnoreCase(currentElement.toString()) &&
						!"ApellidosNombre".equalsIgnoreCase(currentElement.toString()) &&
						!"Retenido".equalsIgnoreCase(currentElement.toString()) &&
						!"Retenedor".equalsIgnoreCase(currentElement.toString()) ){
					// para que siga leyendo
					return false; 
				}
				
				switch (currentElement) {
					case NIF:
						if(estamosRetenido){
							retenido.setNif(currentText.toString());
						}
						break; 
						
					case APELLIDOSNOMBRE:
						if(estamosRetenido){
							retenido.setNombre(currentText.toString());
						}
						break; 
					
					case RETENIDO:
						if(buscarRetenido && indiceRetenedorALeer==indiceRetenedorLeido && indiceRetenidoALeer==indiceRetenidoLeido){
							lista.add(retenido);
						}
						else if(!buscarRetenido){
							lista.add(retenido);
						}
						estamosRetenido=false;
						//retenido=new NombreNif()
						retenido=null;
						break;
						
					case RETENEDOR:
						return true;
						
					default:
						break;
				}
			} else {
				// guardamos
				if(indiceRetenedorALeer!=indiceRetenedorLeido || indiceRetenidoALeer!=indiceRetenidoLeido){
					return false;
				}
			
				switch (currentElement) {
					case NIF:		
						modelo.setValor(PerceptorBeanTipos.P_NIFPER, currentText.toString());
						break; 
						
					case APELLIDOSNOMBRE:
						// si estamos en ConvertirXML (XML a programa), el NIF lo rellenamos nosotros
						if(!importarXML){		
							modelo.setValor(PerceptorBeanTipos.P_APEPER, currentText.toString());
						} else {
							modelo.setValor(PerceptorBeanTipos.P_APEPER, modelo.getValor(PerceptorBeanTipos.P_APERET));
						}
						break; 
				
					case ANIONACIMIENTO:
						if(tipoRetiDescAsc==1){
							modelo.setValor(PerceptorBeanTipos.P_ANIOPER, currentText.toString().trim());
						} else if(tipoRetiDescAsc==2){
							descend.setAnioNacimiento(Integer.parseInt(currentText.toString().trim()));
						} else if(tipoRetiDescAsc==3){
							ascend.setAnioNacimiento(Integer.parseInt(currentText.toString().trim()));
						}
						break;
									
					case SITUACION1: 
						modelo.setValor(PerceptorBeanTipos.P_SITUFAM, ""+PerceptorBeanTipos.SITUACION1);
						break;
							
					case SITUACION2: 
						modelo.setValor(PerceptorBeanTipos.P_SITUFAM, ""+PerceptorBeanTipos.SITUACION2);
						break;
							
					case NIFCONYUGE: 
						modelo.setValor(PerceptorBeanTipos.P_NIFCON, currentText.toString());
						break;
							
					case SITUACION3: 
						modelo.setValor(PerceptorBeanTipos.P_SITUFAM, ""+PerceptorBeanTipos.SITUACION3);
						break;
							
					case GRADO1:
						if(tipoRetiDescAsc==1){
							modelo.setValor(PerceptorBeanTipos.P_DISCAPER, ""+PerceptorBeanTipos.ENTRE33Y65);
						}
						if(tipoRetiDescAsc==2){
							descend.setDiscapacidad(PerceptorBeanTipos.ENTRE33Y65);
						}
						if(tipoRetiDescAsc==3){
							ascend.setDiscapacidad(PerceptorBeanTipos.ENTRE33Y65);
						}
						break;
							
					case GRADO2:
						if(tipoRetiDescAsc==1){
							modelo.setValor(PerceptorBeanTipos.P_DISCAPER, ""+PerceptorBeanTipos.MAS65);
						}
						if(tipoRetiDescAsc==2){
							descend.setDiscapacidad(PerceptorBeanTipos.MAS65);
						}
						if(tipoRetiDescAsc==3){
							ascend.setDiscapacidad(PerceptorBeanTipos.MAS65);
						}
						break;
							
					case MOVILIDADREDUCIDA:
						if(tipoRetiDescAsc==1){
							modelo.setValor(PerceptorBeanTipos.P_MOVILPER, "1");
						}
						if(tipoRetiDescAsc==2){
							descend.setMovilidadReducida(true);
						}
						if(tipoRetiDescAsc==3){
							ascend.setMovilidadReducida(true);
						}
						break;
							
					case RESIDENCIACEUTAMELILLA:
						modelo.setValor(PerceptorBeanTipos.P_RESICEME, "1");
						break;
							
					case TRABAJADORACTIVO:
						modelo.setValor(PerceptorBeanTipos.P_SITUPER, ""+PerceptorBeanTipos.ACTIVO);
						break;
							
					case DESEMPLEADO:
						modelo.setValor(PerceptorBeanTipos.P_SITUPER, ""+PerceptorBeanTipos.DESEMPLEADO);
						break;
							
					case PENSIONISTA:
						modelo.setValor(PerceptorBeanTipos.P_SITUPER, ""+PerceptorBeanTipos.PENSIONISTA);
						break;
							
					case OTRASITUACION:
						modelo.setValor(PerceptorBeanTipos.P_SITUPER, ""+PerceptorBeanTipos.OTRASSITUACIONES);
						break;
							
					case CONTRATO:
						modelo.setValor(PerceptorBeanTipos.P_CONTRATO, currentText.toString().trim());
						break;
							
					case MOVILIDADGEOGRAFICA:
						modelo.setValor(PerceptorBeanTipos.P_MOVIL, "1");
						break;
						
						// 2016 QUITAMOS CAMBIORESI
				/*	case CambioResidencia:
						modelo.setValor("CAMBIORESI", currentText.toString().trim())
						break
				*/			
					case ANIOADOPCION:
						descend.setAnioAdopcion(Integer.parseInt(currentText.toString().trim()));
						break;
							
					case COMPUTADOENTERO:	
						descend.setPorEntero(true);
						break;
							
					case CONVIVENCIA:
						ascend.setConvivencia(Integer.parseInt(currentText.toString().trim()));
						break;
							
					case DESCENDIENTE:
						datosDescendientes.add(descend);
						break;
							
					case ASCENDIENTE:
						datosAscendientes.add(ascend);
						break;
							
					case RETRIBANUALES:
						modelo.setValor(PerceptorBeanTipos.P_RETRIB, currentText.toString().trim());
						break;
							
					case IRREGULARIDAD1:
						modelo.setValor(PerceptorBeanTipos.P_IRREGULAR1, currentText.toString().trim());
						break;	
							
					case IRREGULARIDAD2:
						modelo.setValor(PerceptorBeanTipos.P_IRREGULAR2, currentText.toString().trim());
						break;	
							
					case COTIZACIONES:
						modelo.setValor(PerceptorBeanTipos.P_COTIZACIONES, currentText.toString().trim());
						break;	
							
					case PENSIONCOMPENSATORIA :
						modelo.setValor(PerceptorBeanTipos.P_CONYUGE, currentText.toString().trim());
						break;	
							
					case ANUALIDADESHIJOS :
						modelo.setValor(PerceptorBeanTipos.P_ANUALIDADES, currentText.toString().trim());
						break;	
							
					case RDTOSOBTENIDOSCEUTAMELILLA :
						modelo.setValor(PerceptorBeanTipos.P_RENCEME, "1");
						break;	
							
					case PAGOPRESTAMOSVIVIENDA :
						modelo.setValor(PerceptorBeanTipos.P_PRESVIV, "1");
						break;	
							
					case CAUSA:
						if(!importarXML){
							int indiceCausa = Integer.parseInt(currentText.toString().trim());
							modelo.setValor(PerceptorBeanTipos.P_CAUSA, true, indiceCausa);
						}
						break;
							
						//Retribuciones ya satisfechas con anterioridad a la regularizacin
					case RETRIBSATISFECHAS:
						if(!importarXML){
							modelo.setValor(PerceptorBeanTipos.P_PERCIBIDO, currentText.toString().trim());
						}
						break;
						
						//Retenciones e ingresos a cuenta ya practicados con anterioridad a la regularizacin
					case RETENCIONPRACTICADA:
						if(!importarXML){
							modelo.setValor(PerceptorBeanTipos.P_RETENIDO, currentText.toString().trim());
						}
						break;
					
						//Retribuciones anuales consideradas con anterioridad a la regularizacin
					case RETRIBANUALESINICIALES:
						if(!importarXML){
							modelo.setValor(PerceptorBeanTipos.P_RETRIBA, currentText.toString().trim());
						}
						break;
	
						//Importe anual de las retenciones e ingresos a cuenta determinadas antes de la regularizacin
					case RETENCIONANUALINICIAL:
						if(!importarXML){
							modelo.setValor(PerceptorBeanTipos.P_IMPORTEA, currentText.toString().trim());
						}
						break;
	
						//Los rendimientos anteriores a la regularizacin fueron obtenidos en Ceuta o Melilla
					case RESIDENCIAINICIALCEUTAMELILLA:
						if(!importarXML){
							modelo.setValor(PerceptorBeanTipos.P_RENCEMEA, "1");
						}
						break;
				
						//Base para calcular el tipo de retencin determinado antes de la regularizacin
					case BASERETENCION:
						if(!importarXML){
							modelo.setValor(PerceptorBeanTipos.P_BASEA, currentText.toString().trim());
						}
						break;
	
						//Mnimo personal y familiar para calcular el tipo de retencin determinado antes de la regularizacin
					case MINIMOPERSONALFAMILIARINICIAL:
						if(!importarXML){
							modelo.setValor(PerceptorBeanTipos.P_MINPERFAA, currentText.toString().trim());
						}
						break;
	
						//Tipo de retencin aplicado con anterioridad a la regularizacin
					case TIPORETENCION:
						if(!importarXML){
							modelo.setValor(PerceptorBeanTipos.P_TIPOA, currentText.toString().trim());
						}
						break;
				
						//En algn momento antes de la regularizacin se aplic minoracin por pagos de prstamos para la vivienda
						//MINORADO
						//Importe de la minoracin por pagos de prstamos para la vivienda determinado antes de la regularizacin
					case MINORACIONPRESTAMOSVIVIENDA:
						if(!importarXML){
							modelo.setValor(PerceptorBeanTipos.P_MINORADO, "1");
							modelo.setValor(PerceptorBeanTipos.P_MINOPAGOA, currentText.toString().trim());
						}
						break;
			
					case RETENIDO:
						estamosRetenido=false;
						// borramos datos
						datosAscendientes=null;
						datosDescendientes=null;
						descend=null;
						causas=null;
						return true;
						
					default:
						break;
				}
			}
			
			currentElement = null; 
			currentText = null; 
		}

		return false;
	}


	private Logger getLog() {
		return Logger.getLogger(PerceptorBeanImpl.class.getName());
	}
}
